#include "mbed.h"

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

Serial pc(USBTX, USBRX); // tx, rx

// for serial comunication look under device manger what comX port your mbed got
// and setup your terminal prog to the comX port
// communication defaults for the mbed is 9600-8-N-1
// pc.putc(pc.getc()); gives you a callback for each char you'll hack in the terminal interface
        
int main(void) {
    
    float brigthness[4] = {0.0, 0.0, 0.0, 0.0};
    unsigned char ch = '\0';
    unsigned char cmd = '\0';  
    
    pc.printf("\n\t\tSerial-Dimmer\n\n");
    pc.printf("Press:\t1 - LED 1\n");
    pc.printf("\t2 - LED 2\n");
    pc.printf("\t3 - LED 3\n");
    pc.printf("\t4 - LED 4\n");
    pc.printf("\tu - to increase the chosen led\n");
    pc.printf("\td - to dimm the chosen led\n");
    pc.printf("\te - exit\n\n");
    
    
    while(cmd != 'e') {
        
        cmd = pc.getc();
        
        if((cmd == '1') || (cmd == '2') || (cmd == '3') || (cmd == '4')) {
            pc.printf("Choosed LED %c\n", cmd);
            ch = cmd;
        }
        
        switch(ch) {
            
            case '1':
                if((cmd == 'u') && (brigthness[0] < 1.0)) {
                    brigthness[0] += 0.01;
                    led1 = brigthness[0];
                
                }if((cmd == 'd') && (brigthness[0] > 0.0)) {
                    brigthness[0] -= 0.01;
                    led1 = brigthness[0];
                }    
                break;
                
            case '2':
                if((cmd == 'u') && (brigthness[1] < 1.0)) {
                    brigthness[1] += 0.01;
                    led2 = brigthness[1];
                }
                if((cmd == 'd') && (brigthness[1] > 0.0)) {
                    brigthness[1] -= 0.01;
                    led2 = brigthness[1];
                }
                break;
                
            case '3':
                if((cmd == 'u') && (brigthness[2] < 1.0)) {
                    brigthness[2] += 0.01;
                    led3 = brigthness[2];
                }
                if((cmd == 'd') && (brigthness[2] > 0.0)) {
                    brigthness[2]-= 0.01;
                    led3 = brigthness[2];
                }
                break;
                
            case '4':  
                if((cmd == 'u') && (brigthness[3] < 1.0)) {
                    brigthness[3] += 0.01;
                    led4 = brigthness[3];
                }
                if((cmd == 'd') && (brigthness[3] > 0.0)) {
                    brigthness[3] -= 0.01;
                    led4 = brigthness[3];
                }
                break;
                
            default:
                break;
        }
    }
    pc.printf( "\n\n\t\tQuit Serial-Dimmer!\n\n"); 
    pc.printf("=============================================\n");
    pc.printf("=============================================\n");  
    return 0;
}
