/* Author:  Tobias Wulf
 * Date:    13.09.2013
 * Reason:  don't know why...
 *
 * http://www.ascii-art.de/ascii/my/
 *                                                        Z
  |\/|     /\  _ _oo   /\ .__|_                   Z
  |  |\/  /--\_>(_||  /--\|  |_   .,.,        z
      /                          ((((())    z
                               ((('_  _`) '
    _______________________    ((G   \ |)      ___________________
                              (((`   " ,
                               .((\.:~:          .--------------.
     The product               __.| `"'.__      | \              |
                            .''   `---'   `.    |  .             :
     of hard work          /                `   |   `-.__________)
                          |             ~       |  :             :
     for many many        |                     |  :  |
                          |    _                |     |   [ ##   :
     hours ...             \    `--.        ____|  ,   oo_______.'
                            `_   ( \) _____/     `--___
                            | `--)  ) `-.   `---   ( - a:f -
                            |   '///`  | `-.
                            |     | |  |    `-.
                            |     | |  |       `-.
                            |     | |\ |
                            |     | | \|
                             `-.  | |  |
                                `-| '
 */

#include "mbed.h"

#ifndef MBED_PWMDAC_H
#define MBED_PWMDAC_H

#ifndef SYS_CLK
#define SYS_CLK 96000000 // Hz
#endif


 /**
 * Is used as PWM port with possibility 
 * to update all PWM channel at once. So you can use it
 * although as multichannel DAC with lowpass filters
 * wich match your application.
 * For deeper information look at the wiki.
 *
 * If you want to use only one PWM or you have some other
 * plans for the rest of the PWM port you should use FastPwm
 * or PwmOut objects
 * 
 * This is only working for mbed LPC1768!!
 */



class PwmDAC {

    public:
    
        /**
        * Initialize the PwmDAC object wich set up all channels. 
        */
        void init();
        
        /**
        * Deactivate a single channel and pull it to ground (intern pull down)
        * or deactivate all if ch greater than 5.
        * @param - ch is an integer number 0 - 5.
        */
        void deactivate(unsigned int ch);

        /**
        * Activate a single channel and deactivate intern pull up/ down
        * or activate all if ch greater than 5.
        * @param - ch is an integer number 0 - 5.
        */
        void activate(unsigned int ch);
        
        /**
        * Set PWM frequency in Hz. This setting includes all channels.
        * Maximum is 48000000Hz.
        * @param - frequency in Hz. Argument is type of double
        */
        void setFrequency(double frequency);
        
        /**
        * Set PWM period in seconds
        * @param - seconds is type of double
        */
        void setPeriod(double seconds);
        
        /**
        * Set the PWM step resolution. Use it instead setFrequency()
        * @param - resolution min is 2 max is 2^31
        */
        void setResolution(uint32_t resolution);
        
        /**
        * Update the 6 PWM channels.
        * @param - argument must be an array larger 6 and type of double
        */
        void updateDuty(double duty[]);
        
        /**
        * Update the 6 PWM channels.
        * @param - argument must be an array larger 6 and type of double
        */
        void updatePulsewidth(double pulsewidth[]);
        
        /**
        * Update the 6 PWM channels.
        * @param - argument must be an array larger 6 and type of uint32_t
        */
        void updateSteps(uint32_t steps[]);

        /**
        * Stop PWM
        */
        void stop();
        
        /**
        * Start PWM
        */
        void start();

    private:
        double _frequency; // [Hz]
        double _period; // [sec]
        double _pulsewidth[6]; // [sec]
        double _duty[6]; // [%]
        uint32_t _steps[6];
        uint32_t _resolution;
        bool _allActive;
        
        __IO uint32_t *MR[7];
};
#endif