/* ADC Test
 * 
 * Project:         DiscoTech
 * HDK/ SDK Eng:    Tobias Wulf
 * Date:            21.09.2013
 *
 */
 
#include "mbed.h"
#include "Terminal.h"

#include "adc.h"


#include "stdlib.h"

#define SAMPLE_RATE 48000 //Hz
#define ADC_BIAS 1.65 //Volts
#define ULSB 3.3 / 4095
#define RESOLUTION 256

#define MASK 0x07 // for shift register

#define NUMBER_OF_SAMPLES 1024

/* declair your functions
 * isr routine doesn't have to be declaired
 */
void mainInit();


ADC adc(SAMPLE_RATE, 1);

/* Serial communication via usb uplink to pc
 * to display what ever you want in the terminal
 * or to send what ever you want from the terminal
 */
Terminal usbPC(USBTX, USBRX);


/* global variables to work in the adc interrupt
 * service routine to get the data from interrupt
 */

double newSample;

bool save;

double adcMin;
double adcMax;
double adcAverage;
double adcSavings[NUMBER_OF_SAMPLES];

int main() {
        
    usbPC.printf("...start program\n");
    wait(0.2);

    mainInit();
    usbPC.printf("...init completed\n");
    wait(0.2);


    while(1) {
        
        if(save == false) {
        
           usbPC.locate(0,0);
           usbPC.cls();
           usbPC.printf("Max = %1.4f\tMin = %1.4f\nAverage = %1.4f\tact. Sample = %1.4f\n", adcMax, adcMin, adcAverage, newSample);
           
           for(int i=0; i<NUMBER_OF_SAMPLES; i++)
                usbPC.printf("%1.4f\n",adcSavings[i]);
        }
        
        if(save == false) break;
        
    }        
}/* end main */




/* interrupt service routine from adc object
 * here should be done the data processing
 * variable and output updates
 */
void getADC(int chan, uint32_t value) {
    //static double adcMax_temp;
    //static double adcMin_temp; //volts max value value
    static double adcTotal = 0.0;
    static double adcSample;
    static long cycleCounter = 0;

    adcSample = (double) adc.read(p15);
    adcSample = adcSample * ULSB; // - ADC_BIAS;
  
    adcTotal += adcSample;
    cycleCounter++;
    
    if (adcSample < adcMin)
                adcMin = adcSample;
                
    if (adcSample > adcMax)
                adcMax = adcSample;
                
    
    if(cycleCounter < NUMBER_OF_SAMPLES) {
       adcSavings[cycleCounter] = adcSample;
       if((cycleCounter == NUMBER_OF_SAMPLES-1) && save) {
            save = false;
            
            newSample = adcSample; 
            //adcMax = adcMax_temp;
            adcAverage = (double)(adcTotal / cycleCounter);
            //adcMin = adcMin_temp;
            adcMax = 0.0;
            adcMin = 3.3;
            adcTotal = 0.0;
            cycleCounter = 0;
       }
    }
}        

/* function to initialize the main program, objects and 
 * implement all variables
 */
void mainInit() {

    save = true;

    adcMin = 3.3;
    adcMax = 0.0;
    adcAverage = 0.0;
    
    for (int i = 0; i < NUMBER_OF_SAMPLES; i++)
        adcSavings[i] = 0.0f;      
    


    usbPC.printf("...variables implemented\n");
    wait(0.2);
    
    
    /* setup adc input
     */
    adc.append(&getADC);
    
    adc.startmode(0,0);
    adc.burst(1);
   
    adc.setup(p15,1);
    adc.setup(p16,0);
    adc.setup(p17,0);
    adc.setup(p18,0);
    adc.setup(p19,0);
    adc.setup(p20,0);
   
    adc.interrupt_state(p15,1);
    
    
    usbPC.printf("%u, %u, %u, %u\n", adc.setup(p15), 
                                     adc.burst(),
                                     adc.interrupt_state(p15), 
                                     adc.actual_sample_rate());   
    
    usbPC.printf("...ADC initialized\n");
    wait(0.2);
    

}