//
// NUCLEO-32
// STM32F303K8
// １から３ボタンにてＬＥＤ点灯、サーボ回転
// 16/09/10 Ver2
// 

#include "mbed.h"
#include "ReceiverIR.h"
#include <stdint.h>

DigitalOut REDled(D11);
DigitalOut YELled(D10);
DigitalOut GREled(D9);
PwmOut servo(D7);

Serial pc(USBTX, USBRX);

int main() {
    //パルス出力周期(20ms)
    servo.period(0.020);  
    // PortD12を赤外線受信入力に
    ReceiverIR ir_rx(D12);
    RemoteIR::Format format;
    uint8_t buf[32];
    uint32_t bitcount;

    // シリアル出力のボーレートを115200bpsに設定
    pc.baud(115200);
    pc.printf("start\n");
    
    while(1){
        // 受信待ち
        if (ir_rx.getState() == ReceiverIR::Received) {
            pc.printf("get ir data\n");
            // コード受信
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            if(bitcount < 1){
                // ビット数0のものは無視
                continue;
            }
            // 受信コード出力
            pc.printf("code: ");
            for(int i=0;i<(bitcount>>3);i++){
                pc.printf("%02x",buf[i]);
            }
            pc.printf("\n");
            
            //3byte目でボタン判断
            if (buf[2] == 0x16) {   //１
                servo.pulsewidth(0.0027);//左
                REDled =!REDled;
            }
            if (buf[2] == 0x19) {   //２
                servo.pulsewidth(0.0015);//センター
                YELled =!YELled;
            }
            if (buf[2] == 0x0D) {   //３
                servo.pulsewidth(0.0006);//右
                GREled =!GREled;
            }
        }
    }
}
