#include "mbed.h"
 
#define DELAY 500
 
// Turn ON/OFF the power of EPSON Projector
int ARRAY_HIGHLOW[] = { 
9085, 4425, 666, 1596, 661, 1598, 665, 468, 662, 470, 663, 469, 663, 469, 
660, 472, 663, 1597, 663, 1597, 667, 466, 662, 1597, 666, 466, 664, 1596, 
667, 466, 662, 1598, 666, 466, 663, 470, 664, 468, 662, 470, 663, 469, 664, 
1597, 668, 465, 663, 468, 663, 1598, 664, 1596, 666, 1595, 663, 1597, 665, 
1595, 663, 469, 664, 1596, 665, 1595, 665, 467, 663, 40891, 9085, 4425, 664, 
1597, 663, 1597, 664, 468, 662, 471, 661, 471, 661, 471, 662, 470, 662, 1597, 
664, 1597, 664, 468, 661, 1599, 662, 470, 661, 1599, 662, 471, 661, 1598, 
664, 469, 660, 472, 661, 471, 660, 471, 662, 470, 662, 1598, 664, 469, 661, 
471, 662, 1598, 663, 1597, 662, 1597, 664, 1597, 662, 1598, 662, 471, 661, 
1599, 664, 1596, 665, 467, 663, };
                            
DigitalIn di(D1);
PwmOut po(D0);
 
void sendSignal()
{
    po.period_us( 26 );   // 38KHz => 1/38000[s] = 26.315 * 10 ^ -6 [s] = 26.315 [us]
 
    int iCountHighLow = sizeof( ARRAY_HIGHLOW ) / sizeof( ARRAY_HIGHLOW[0] );
    for( int iIndexHighLow = 0; iIndexHighLow < iCountHighLow; iIndexHighLow++ )
    {
        po.write( 0.5 * (1 - (iIndexHighLow % 2)) );    // iIndexHighLow : even number -> 0.5, uneven number -> 0
        wait_us( ARRAY_HIGHLOW[iIndexHighLow] );
    }
    po.write(0); 
}