#include "mbed.h"

DigitalIn di(D2);
Serial ser(USBTX, USBRX);

int main()
{
    di.mode( PullNone ); // mode : PullUp, PullDown, PullNone, OpenDrain
    ser.baud(115200);

    Timer timer;
    timer.start();
    int iMicroSec_prev = timer.read_us();
    int iState_prev = 1;
    while(1)
    {
        int iState = di;
        if( iState != iState_prev )
        {
            iState_prev = iState;
            int iMicroSec = timer.read_us();
            ser.printf( "%d, ", iMicroSec - iMicroSec_prev );
            iMicroSec_prev = iMicroSec;
        }
    }
}
