#include "mbed.h"
#include "ReceiverIR.h"

Serial ser(USBTX, USBRX);
BusOut  leds( D1,D0,D4,D5 );

int main() {

    ReceiverIR ir_rx(D2);
    RemoteIR::Format format;
    uint8_t buf[32];
    uint32_t bitcount;

    ser.baud(115200);
    ser.printf("start\r\n");
    
    while(1){
        if (ir_rx.getState() == ReceiverIR::Received) {
            ser.printf("get ir data\r\n");
                bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            if(bitcount < 1){
                continue;
                }
            ser.printf("code: ");
            for(int i=0;i<(bitcount>>3);i++){
                ser.printf("%02x",buf[i]);
            uint8_t code = buf[2];
            switch(code){
                case 0x40:
                    leds = 0;
                    break;               
                case 0x16:
                    leds = 1;
                    break;
                case 0x19:
                    leds = 2;
                    break;
                case 0x0d:
                    leds = 3;
                    break;
                case 0x0c:
                    leds = 4;
                    break;
                case 0x18:
                    leds = 5;
                    break;
                case 0x5e:
                    leds = 6;
                    break;
                case 0x08:
                    leds = 7;
                    break;
                case 0x1c:
                    leds = 8;
                    break;
                case 0x5a:
                    leds = 9;
                    break;
                case 0x52:
                    leds = 10;
                    break;
                        }    
                    }
            ser.printf("\r\n");
        }
    }
}