/**
 * Biofeedback Badgers - UW Madison
 * Fall 2020
 * v01 Start Date: 2020/10/22
 * v01 Last Edit: 2020/11/21
 *
 * This header file contains constants used by Biofeedback Badgers to record EMG
 * and temperature data for their senior design project.
 *
 * Version 01.3
 * 
 * Contributors: Will Wightman
 */
// Constants used and describes by BFB.
#ifndef __BFB_Configs_v01__
#define __BFB_Configs_v01__

// Buffer and data constants
const int BUF_LEN = 256;                // (BUF_LEN * T_<max>) =< (1/8)
const unsigned short FOOTER = 0;        // Indicates end of transmission block
const unsigned short DATA_BIT = 0x8000; // Indicates a data block

// Constants to define program's function
const float T_EMG = 595E-6; // 3000 Hz            // EMG sampling period in secs (3 kHz)
const float T_TEMP = 250E-3;            // Temperature sampling period in secs

// Constant IDs for for EMG and Temperature collection
const unsigned short EMG_TAG = 2 << 12;          // Sampling tag = 0
const unsigned short TEMP_TAG = 1 << 12;         // Sampling tag = 1

// Constant values for maximum and minimum total gains.
const float MAX_GAIN = 13E3;    // V/V
const float MIN_GAIN = 600;     // V/V
const int MAX_GAIN_N = 128;     // Maximum integer value to calculat R_wb
const int MIN_GAIN_N = 0;       // Minimum integer value to calculat R_wb
const float GAIN_REG = 516.16;  // Baseline gain

#endif // __BFB_Configs_v01__