#include "mbed.h"
#define SLAVE_MOSI  (PA_7)
#define SLAVE_MISO  (PA_6)
#define SLAVE_SCLK  (PA_5)
#define SLAVE_SSEL  (PA_15)
 
 
SPISlave spi_slave(SLAVE_MOSI,
                   SLAVE_MISO,
                   SLAVE_SCLK,
                   SLAVE_SSEL);
Serial pc(USBTX,USBRX,115200); // 3rd parameter is baud rate

int main()
{
    char buf[128];
    unsigned count = 0;
    memset(buf, 0, sizeof(buf));
    printf("SPI slave start\r\n");
    wait(2);

    spi_slave.reply(0);
    
    for(;;) {
        if(spi_slave.receive()) {
            int rcv = spi_slave.read();
            buf[count++] = rcv;
            if (rcv)
                spi_slave.reply(0);
        } else if(count > 10) {
            printf("SPI message:\r\n");
            printf("%s\r\n", buf);
            memset(buf, 0, sizeof(buf));
            count = 0;
        }
    }
}

