#include "mbed.h"
#include "uLCD_4DGL.h"
#include "food.h"
#include <algorithm>

#define BREAD 1
#define LETTUCE 2
#define CHEESE 3
#define TOMATO 4
#define BADLETTUCE 5
#define BADCHEESE 6
#define BADTOMATO 7

#define MAX(i) std::max(i,0)
#define MIN(i) std::min(i,128)

#define MAROON 0x8b0000
#define DARKBROWN 0x654321
#define YELLOW 0xffff00
#define PURPLE 0x551a8b
#define BROWN 0xf4a460

Food::Food(uLCD_4DGL * uLCD) {
    lcd = uLCD;
    typeOfFood = BREAD;
    isBad = false;
    // leave x and y uninitialized?
}

Food::Food(int type, int location, uLCD_4DGL * uLCD) {
    lcd = uLCD;
    typeOfFood = type;
    isBad = (type == BADLETTUCE
        || type == BADTOMATO || type == BADCHEESE) ? true : false;
    x = location;
    y = 1;
}

void Food::draw() {
    switch (typeOfFood) {
        case LETTUCE: drawLettuce(GREEN);
            break;
        case TOMATO: drawTomato(RED);
            break;
        case CHEESE: drawCheese(YELLOW);
            break;
        case BREAD: drawBread();
            break;
        case BADLETTUCE: drawLettuce(PURPLE);
            break;
        case BADTOMATO: drawTomato(PURPLE);
            break;
        case BADCHEESE: drawCheese(PURPLE);
            break;
    }
}

void Food::drawLettuce(int color) {
    lcd->filled_rectangle(x, y, x + 15, y + 3, color);
    /*
    lcd->pixel(x + 1, y, BLACK);
    lcd->pixel(x + 3, y, BLACK);
    lcd->pixel(x + 5, y, BLACK);
    lcd->pixel(x, y + 3, BLACK);
    lcd->pixel(x + 6, y + 3, BLACK);
    lcd->pixel(x + 7, y + 3, BLACK);
    */
}

void Food::drawTomato(int color) {
    lcd->filled_rectangle(x, y, x + 15, y + 3, color);
    /*
    lcd->line(x + 2, y, x + 5, y, 0x8b0000);
    lcd->line(x + 2, y + 3, x + 5, y + 3, color);
    lcd->line(x, y + 1, x + 1, y + 1, MAROON);
    lcd->line(x, y + 6, x + 1, y + 7, MAROON);
    */
}

void Food::drawCheese(int color) {
    lcd->filled_rectangle(x, y, x + 15, y + 3, color);
    /*
    lcd->pixel(x, y + 7, WHITE);
    lcd->pixel(x + 1, y + 5, WHITE);
    lcd->filled_rectangle(x + 2, y + 2, x + 3, y + 3, WHITE);
    */
}

void Food::drawBread() {
    lcd->filled_rectangle(x, y, x + 15, y + 3, BROWN);
    /*
    lcd->pixel(x, y, BLACK);
    lcd->pixel(x, y + 3, BLACK);
    lcd->pixel(x, y + 1, DARKBROWN);
    lcd->pixel(x, y + 2, DARKBROWN);
    */
}

void Food::erase() {
    lcd->filled_rectangle(x, y, x + 15, y + 3, BLACK);
}

void Food::fall() {
    erase();
    y = y + 1;
    draw();
}