#include "mbed.h"
#include "uLCD_4DGL.h"
#include "stack.h"
#include "food.h"
#include <algorithm>
#include <vector>

#define BREAD 1
#define LETTUCE 2
#define CHEESE 3
#define TOMATO 4
#define BADLETTUCE 5
#define BADCHEESE 6
#define BADTOMATO 7

#define MAX(i) std::max(i,0)
#define MIN(i) std::min(i,107)


Stack::Stack(int location, uLCD_4DGL * uLCD) {
    x = location;
    Food bread(uLCD);
    stackOfFood.push_back(bread);
    lcd = uLCD;
    top = 122;
}

void Stack::move(int dx) {
    // constrain 
    erase();
    if (dx < 0) x = MAX(x + dx);
    else x = MIN(x + dx);
    draw();
}

int Stack::size() {
    return stackOfFood.size();
}

void Stack::clear() {
    erase();
    stackOfFood.clear();
    Food bread(lcd);
    stackOfFood.push_back(bread);
    draw(); 
}

void Stack::erase() {
    // ERASE
    lcd->filled_rectangle(x, 125, x + 15, top, BLACK);
    lcd->filled_rectangle(x - 1, 126, x + 17, 127, BLACK);
}

void Stack::draw() {
    // DRAW (loop thru food vector)
    lcd->filled_rectangle(x - 1, 126, x + 17, 127, WHITE);
    int j = 122;
    for (int i = 0; i < stackOfFood.size(); i++) {
        stackOfFood[i].x = x;
        stackOfFood[i].y = j;
        stackOfFood[i].draw();
        j -= 4;
    }
}

void Stack::add(Food * collided) {
    collided->x = x;
    collided->y = top;
    top -= 4;
    stackOfFood.push_back(*collided);
    draw();
}