#include "mbed.h"
#include "uLCD_4DGL.h"
//#include "SongPlayer.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "NavSwitch.h"
#include "food.h"
#include "stack.h"
#include <ctime>
#include <cstdlib>
#include <cmath>  
#include <vector>

#define BREAD 1
#define LETTUCE 2
#define CHEESE 3
#define TOMATO 4
#define BADLETTUCE 5
#define BADCHEESE 6
#define BADTOMATO 7

#define MAROON 0x8b0000
#define DARKBROWN 0x654321
#define YELLOW 0xffff00
#define PURPLE 0x551a8b
#define BROWN 0xf4a460

uLCD_4DGL lcd(p9,p10,p11);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
Nav_Switch joystick(p20, p19, p17, p16, p15); // pin order on Sparkfun breakout
DigitalIn speed(p21);
DigitalIn pause(p22);

vector<Food> foods;
Food * collided;

using namespace std;
Stack sandwich(64,&lcd);
int score, lives;
float clk, clk2;
Timer t;
int indexToRemove;

bool collisionCheck();
void updateScore(int);
void drawLives();

int main() {
    speed.mode(PullUp);
    pause.mode(PullUp);
    
    // splash sequence
    lcd.filled_rectangle(34, 18, 44, 19, BROWN); 
    lcd.filled_rectangle(30, 22, 50, 20, BROWN); // top bun
    lcd.filled_rectangle(34, 38, 44, 42, YELLOW); // cheese
    lcd.filled_rectangle(34, 56, 44, 60, GREEN); // lettuce
    lcd.filled_rectangle(34, 74, 44, 78, RED); // tomato
    lcd.filled_rectangle(30, 94, 50, 96, BROWN); // bottom bun
    lcd.filled_rectangle(34, 98, 44, 97, BROWN); 
    
    FILE *wave_file;
    wave_file=fopen("/sd/start.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    
    lcd.text_string("bun", 11, 3, FONT_7X8, WHITE);
    wait(1);
    lcd.text_string("cheese", 11, 5, FONT_7X8, WHITE);
    wait(1);
    lcd.text_string("lettuce", 11, 7, FONT_7X8, WHITE);
    wait(1);
    lcd.text_string("tomato", 11, 9, FONT_7X8, WHITE);
    wait(1);
    lcd.text_string("bun", 11, 11, FONT_7X8, WHITE);
    wait(4);
    lcd.cls();
    
    lcd.filled_rectangle(34, 38, 44, 42, MAROON); // bad foods
    lcd.filled_rectangle(34, 56, 44, 60, DARKBROWN);
    lcd.filled_rectangle(34, 74, 44, 78, PURPLE);
    wait(2);
    lcd.text_string("GROSS!", 11, 7, FONT_7X8, WHITE);
    wait(2);
    lcd.cls();
    
    score = 0;
    lives = 3;
    t.start();
    srand(time(NULL));
    clk = clk2 = 0;
    sandwich.draw();
    
    lcd.line(108, 1, 108, 128, WHITE);
    
    // inital lives
    lcd.filled_circle(118, 80, 3, YELLOW); // x, y, radius, color
    lcd.filled_circle(118, 90, 3, YELLOW);
    lcd.filled_circle(118, 100, 3, YELLOW);
    
    updateScore(0);
    
    while(lives) {
        if (!pause) { // pause game
            lcd.text_string("PAUSED", 6, 7, FONT_7X8, WHITE);
            int paused = 1;
            while (paused) {
                wait(.2);
                paused = pause;
            }
            lcd.text_string("PAUSED", 6, 7, FONT_7X8, BLACK);
        }
        
        if (joystick.up()) {
            sandwich.move(-1);
        } else if (joystick.down()) {
            sandwich.move(+1);
        }
        if (collisionCheck()) {
            collided->erase();
            if (collided->isBad) {
                lives--;
                drawLives();
                // make a noise!1111
            } else if (collided->typeOfFood == BREAD) {
                // updateScore(sandwich.size()); // add the points to the overall score
                sandwich.clear(); // should redraw
                // make a noise!!11
            } else {
                // remove from falling object list, erase
                foods.erase(foods.begin() + indexToRemove);
                sandwich.add(collided);
            }
        }
        // every 3 seconds add new food! use timer.
        float curr = t.read();
        if (curr - clk >= 5.0) {
            clk = curr;
            // lcd.printf(" new ");
            int x = rand()%90+1;
            int type = rand()%7+1;
            Food item(type, x, &lcd);
            foods.push_back(item);
            // add new food
        }
        // every .2 second each food should fall a lil bit! use timer.
        if (curr - clk2 >= 0.1) {
            clk2 = curr;
            // lcd.printf(" fall ");
            for (int i = 0; i < foods.size(); i++) {
                Food * f = &foods[i];
                f->fall();
            }
            // each food should fall a lil bit!
        }
    }
    
    lcd.cls();
    
    char message[20];
    sprintf(message, "Your score? %d", score);
    while (true) { // end game
        lcd.text_string(message, 1, 7, FONT_7X8, WHITE);
        wait(0.7);
        lcd.text_string(message, 1, 7, FONT_7X8, BLACK);
        wait(0.4);
    }
}

bool collisionCheck() {
    if (!foods.empty()) {
        Food * f = &foods.front();
        if (f->y > 128) foods.erase(foods.begin()); // removed if offscreen!
    }
    for (int i = 0; i < foods.size(); i++) {
        if (foods[i].y + 6 == sandwich.top) {
            if (abs(foods[i].x - sandwich.x) < 8) {
                collided = &foods[i];
                indexToRemove = i;
                return true;
            } else break;
        }
    }
    return false;
    // find foods that have an (x,y) that is within the range of the top of the stack
    // if nothing found w/i the range
        // return false
    // if something found
        // collidedFood = that food item
        // return true
}

void updateScore(int sandwichSize) {
    char scoreString[2];   // max 2-digit score

    FILE *wave_file;
    wave_file=fopen("/sd/score.wav","r");
    waver.play(wave_file);
    fclose(wave_file);

    score += sandwichSize;
    score = (score > 99) ? score - 100 : score; // score rollover
    sprintf(scoreString, "%d", score); // keep score as a char string
    lcd.text_string(scoreString, 16, 1, FONT_7X8, WHITE); // 16 chars over, 1 down
}

void drawLives() {
    
    FILE *wave_file;
    wave_file=fopen("/sd/life.wav","r");
    waver.play(wave_file);
    fclose(wave_file);

    if (lives == 2) {
        lcd.filled_circle(118, 80, 3, BLACK); // erase the life symbol
    }
    else if (lives == 1) {
        lcd.filled_circle(118, 90, 3, BLACK);
    }
    else if (lives == 0) {
        lcd.filled_circle(118, 100, 3, BLACK);
    }   
}
