#include <fstream>
#include <string>
#include "mbed.h"
#include "LSM9DS1.h"
#include "math.h"
#include "uLCD_4DGL.h"
#include "Servo.h"
#include "Motor.h"
#include "StepperMotor_X27168.h"
#include "SDFileSystem.h"
#include "SongPlayer.h"


/* Serial via USB
Serial pc(USBTX, USBRX);
*/

/* Sine wave output pin
AnalogOut aout(p18);
*/

/* IR distance sensor
AnalogIn ain(p15);                // p15 <- senor out, yellow
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
*/

/* IMU, using I2C
LSM9DS1 imu(p9, p10, 0xD6, 0x3C); // dev SDA, SCL
*/

/* RS232 Serial
Serial pc(p13, p14);              // dev RX, TX (serial)
*/

/* LCD level and compass
uLCD_4DGL lcd(p28, p27, p30);     // dev RX, TX, reset. Use +5 (Vu)
int ax, ay;
double theta;
*/

/* Control high current device with xtor/relay
DigitalOut binaryCtrl(p25);       // control signal
DigitalOut myled(LED1);
*/

/* With Power MOSFET for pwm */          
PwmOut pwmCtrl(p25);              // digital control with pwm
PwmOut myled(LED1);

/* Servo movement
Servo myservo(p21);               // dev yellow. Use Vu
*/

/* DC Motor control with H-bridge
Motor m(p23, p11, p12);           // pwm control, fwd, rev
*/

/* Stepper motor
// pwmA and B set to 3.3V (no speed control, only directional)
// A poles on left side (top view). A1 pole to A02, etc.
StepperMotor_X27168 smotor(p25, p26, p23, p22); // bfwd, brev, afwd, arev
*/

/* MEMS microphone
BusOut myleds(LED1,LED2,LED3,LED4);

class microphone
{
    public :
        microphone(PinName pin);
        float read();
        operator float ();
    private :
        AnalogIn _pin;
};

microphone::microphone (PinName pin):
    _pin(pin)
{
}

float microphone::read()
{
    return _pin.read();
}

inline microphone::operator float ()
{
    return _pin.read();
}
 
microphone mymicrophone(p16);
*/

/* SPI bus: microSD card
SDFileSystem sd(p5, p6, p7, p8, "sd");  mosi -> DI, miso <- DO, slck -> sclck, CS -> CS
// CD on device could be used in PullUp mode to check if a card is present
*/

/* Speaker
float note[16]= {329.628,329.628,329.628,349.228,391.995,391.995,391.995,349.228,
                 329.628,349.228,391.995,349.228,329.628,293.665,329.628,349.228
                };
float duration[16]= {0.48,0.12,0.48,0.12,0.48,0.12,0.12,0.12,
                     0.12,0.12,0.12,0.12,0.48,0.12,1.68,0.12
                     };
*/


int main() {
    
    /* Sine wave output pin
    const double pi = 3.141592653589793238462;
    const double amplitude = 1.0f; // 3.3 V
    const double offset = 65535/2; // 0xFFFF/2, half the full 3.3V
    double rads = 0.0;
    uint16_t sample = 0;
    */
    
    /* RS232 Serial, LCD bubble level
    imu.begin();
    if (!imu.begin()) {
        pc.printf("Failed to communicate with imu9DS1.\n");
    }
    imu.calibrate();
    */
    
    /* Servo movement
    // servo adjusts until desired angle is sensed, determind by the pulse width
    // width varies from 1 - 2 ms, 1ms - 0 deg, 1.5 - 90 deg, 2 ms - 180
    // servo updates below every 20ms
    for(float p=0; p<1.0; p += 0.1) {
        myservo = p;
        wait(0.2);
    }
    */
        
    /* DC Motor control with H-bridge
    for (float s= -1.0; s < 1.0 ; s += 0.01) {
        m.speed(s); 
        wait(0.02);
    }
    */
        
    /* Stepper motor
    smotor.step_position(180);
    wait(0.5);
        
    smotor.step_position(100);
    wait(0.5);
        
    smotor.angle_position(270);
    wait(0.5);

    smotor.step_position(0);
    wait(0.5);
    */
    
    /* SPI bus: microSD card
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    
    fprintf(fp, "Hello SD file World!");
    fclose(fp); 
    
    std::ifstream file("/sd/mydir/sdtest.txt");
    string str;
    
    while (std::getline(file, str))
    {
        const char * c = str.c_str();
        pc.printf(c);
    }
    */
    
    /* Speaker
    SongPlayer mySpeaker(p26); // pwm pin
    // Start song and return once playing starts
    mySpeaker.PlaySong(note, duration);
    */
    
    while (1) {
        
        /* Sine wave output pin
        for (int i = 0; i < 720; i++) {
            rads = (pi * i) / 180.0f;
            sample = (uint16_t)(amplitude * (offset * (cos(rads + pi))) + offset);
            aout.write_u16(sample);
        }
        */
        
        /* IR distance sensor
        led1 = (ain > 0.2f) ? 1 : 0; // more LEDs with increasing distance
        led2 = (ain > 0.4f) ? 1 : 0;
        led3 = (ain > 0.6f) ? 1 : 0;
        led4 = (ain > 0.8f) ? 1 : 0;
        wait(.01);
        */
        
        /* RS232 Serial
        imu.readAccel();
        imu.readMag();
        imu.readGyro();
        
        pc.printf("gyro: %d %d %d\n\r", imu.gx, imu.gy, imu.gz);
        pc.printf("accel: %d %d %d\n\r", imu.ax, imu.ay, imu.az);
        pc.printf("mag: %d %d %d\n\n\r", imu.mx, imu.my, imu.mz);
        */
        
        /* LCD level and compass
        imu.readAccel();
        imu.readMag();
        imu.readGyro();
        
        // level

        lcd.filled_circle(64 + ax / 250, 64 + ay/ 250 , 8, BLACK);  // write over past circle
        ax = imu.ax, ay = imu.ay;                                   // get data
        lcd.filled_circle(64 + ax / 250, 64 + ay/ 250 , 8, WHITE);  // draw new 'reading'
        lcd.circle(64, 64, 10, WHITE);                              // redraw the center (constant)
        
        // compass
 
        lcd.line(64,64,64+60*cos(theta), 64+60*sin(theta), BLACK);  // write over past heading
        theta = atan2((double)imu.mx, (double)imu.my);              // get data
        lcd.line(64,64,64+60*cos(theta), 64+60*sin(theta), GREEN);  // draw new heading
        lcd.locate(0,1);
        lcd.printf("%f",180 * theta / 3.14159);                     // write degree heading at the top left
        */
        
        /* Control high current device with xtor/relay
        binaryCtrl = 1;           // slow out because of relay
        myled = 1;
        wait(.2);
        binaryCtrl = 0;
        myled = 0;
        wait(.2);
        */
     
        /* With Power MOSFET for pwm */
        myled = 1.0f;

        for (int i = 0; i < 5; i++) {
            pwmCtrl = i*0.2f;
            myled = pwmCtrl;
            wait(.2);
        }
        
        /* MEMS microphone
        //read in, subtract 0.67 DC bias, take absolute value, and scale up from .1Vpp to 15 (0xFFFF) for builtin LEDs
        myleds = (int) abs( mymicrophone - 0.67/3.3 ) * 500.0;
        //Use an 8kHz audio sample rate (phone quality audio);
        wait(1.0/8000.0);
        */
    }
}