#include "mbed.h"
#include "Grove_temperature.h"
#include "LED_Bar.h"
#include "DigitDisplay.h"
#include "RangeFinder.h"
#include "FXOS8700Q.h"

#define V_SERVO_CENTER 1400
#define V_SERVO_MAX 2200
#define V_SERVO_MIN 800

Serial pc(USBTX, USBRX); // Serial Port 115200

I2C i2c( PTE25, PTE24 );
FXOS8700QAccelerometer  acc( i2c, FXOS8700CQ_SLAVE_ADDR1 ); // Accelerometer

Grove_temperature temp(A3); // Temperature GPIO
DigitalOut myled(LED2);  //Red LED
DigitDisplay display(D7, D8); // Digital Display GPIO

AnalogIn xAxis(A0);  // Joystick x GPIO
AnalogIn yAxis(A1);  // Joystick y GPIO

// Servo
PwmOut v_servo(D3); // D3 output

LED_Bar bar(D6, D5); // LED_Bar GPIO

int x,y,button;  // global variables to hold values

// Seeed ultrasound range finder
RangeFinder rf(A2, 10, 5800.0, 100000);
DigitalOut led(LED1);


Ticker joystick; // recurring interrupt to get joystick data
Ticker tick; // Digital display clock

// Digital Display variables
uint8_t hour   = 20;
uint8_t minute = 14;
uint8_t second = 0;

// Digital Display Algorythm Function
void beat()
{
    static uint8_t colon = 0;
    
    display.setColon(colon);
    if (colon) {
        second++;
        if (second >= 60) {
            second = 0;
            minute++;
            if (minute >= 60) {
                minute = 0;
                
                hour++;
                if (hour >= 24) {
                    hour = 0;
                }
                display.write(0, hour / 10);
                display.write(1, hour % 10);
            }
            display.write(2, minute / 10);
            display.write(3, minute % 10);
        }
    }
    colon = 1 - colon;
}

// Joystick Algorythm Function
void joystick_Int_Handler()
{
    x = xAxis.read() * 1000; // float (0->1) to int (0-1000)
    y = yAxis.read() * 1000;
    if ( (x > 900) || (y > 900) )
        button = 1;
    else
        button = 0;
}

// main() runs in its own thread in the OS
int main() {
    int i;
    pc.baud(115200); // Serial Port 115200
    
    led = 1; //Rangefinder
    float d; //Rangefinder
    
    float   acc_x, acc_y, acc_z; //Accelerometer
    
    // Servo
    int v_pulse = V_SERVO_CENTER;
    v_servo.period_us(20000);          // servo requires a 20ms period
    v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
    wait(1);
    
    // Joystick interrupt, call every .2s
    joystick.attach(joystick_Int_Handler,0.2);
    display.write(0, hour / 10);
    display.write(1, hour % 10);
    display.write(2, minute / 10);
    display.write(3, minute % 10);
    display.setColon(true);
    
    // Dig Display interrupt, call every .5s  
    tick.attach(&beat, 0.5);
    
    // Enable Accelerometer
    acc.enable();
    
    while (true) {
        printf("\r\nTemperature Measurement\r\n");
        pc.printf("\rtemperature = %2.2f\n", temp.getTemperature());
        
        printf("\r\nJoystick Status, Meters\r\n");
        pc.printf("\rX=%3d, Y=%3d, Button=%d\n",x,y,button);
        
        //for (i=0; i<=10; i++) {
        //bar.setLevel(i);
        //wait(0.1);
        //}
        bar.setLevel((x-250)/50);
        
        
        //Servo
        v_pulse =  v_pulse - 20;
        if (v_pulse <= V_SERVO_MIN) v_pulse = V_SERVO_MIN;
        if (v_pulse >= V_SERVO_MAX) v_pulse = V_SERVO_MAX;
        v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
        //wait(3);       
        printf("\n\rPulse = %d\n\r",v_pulse); 

        
        //Range sensor
        d = rf.read_m();
        if (d == -1.0)  {
            printf("\rTimeout Error.\n");   
        } else if (d > 5.0) {  
            // Seeed's sensor has a maximum range of 4m, it returns
            // something like 7m if the ultrasound pulse isn't reflected. 
            printf("\rNo object within detection range.\n");
        } else  {
            printf("\r\nUltra Sonic Rangefinder, Meters\r\n");
            printf("\rDistance = %f m.\n", d);
        }
        
        // get Accelerometer values
        acc.getX( acc_x );
        acc.getY( acc_y );
        acc.getZ( acc_z );
        
        printf("\r\nAccelerometer Values\r\n");
        printf("X:%6.1f, Y:%6.1f, Z:%6.1f\r\n\r\n", acc_x * 90.0, acc_y * 90.0, acc_z * 90.0 );
        
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
        
        led = !led;
    }
}


