/*
 *  FXOS8700.cpp
 */

#include "FXOS8700.h"
 #include "mbed.h"

FXOS8700::FXOS8700(PinName sda, PinName scl) : accelmagi2c(sda,scl)
 {
       
 }
    
 void FXOS8700::accel_config(void)
 {
   char d[2]; 
   d[0] = FXOS8700_CTRL_REG1;                     //Puts device in Standby mode
   d[1] = 0x00; 
   accelmagi2c.write(FXOS8700_I2C_ADDRESS, d,2);   
          
   
   d[0] = FXOS8700_CTRL_REG1;                     //Puts device in Active mode
   d[1] = 0x01;
   accelmagi2c.write(FXOS8700_I2C_ADDRESS, d, 2);   
      
 }
 
  void FXOS8700::mag_config(void)
 {
   char d[2];
   d[0] = FXOS8700_CTRL_REG1;                     //Puts device in Standby mode
   d[1] = 0x00;
   accelmagi2c.write(FXOS8700_I2C_ADDRESS, d,2);   
          
   
   d[0] = FXOS8700_M_CTRL_REG1;                   //Puts device in hybrid mode (both accel and mag are active)
   d[1] = 0x03;
   accelmagi2c.write(FXOS8700_I2C_ADDRESS, d, 2);   
   

   d[0] = FXOS8700_CTRL_REG1;                     //Puts device in Active mode
   d[1] = 0x01;
   accelmagi2c.write(FXOS8700_I2C_ADDRESS, d,2);  
   
 }
 
 void FXOS8700::acquire_accel_data_g(float * a_data)
 {
  
   char data_bytes[7];
   char d[1];
   d[0]=FXOS8700_STATUS;
   accelmagi2c.write(FXOS8700_I2C_ADDRESS,d,1,true);  // Read the 6 data bytes - LSB and MSB for X, Y and Z Axes.
   accelmagi2c.read(FXOS8700_I2C_ADDRESS,data_bytes,7);
   
   a_data[0] =  ((float)((int16_t)(((data_bytes[1]*256) + (data_bytes[2])))>> 2) * 0.000244);
   a_data[1] =  ((float)((int16_t)(((data_bytes[3]*256) + (data_bytes[4])))>> 2) * 0.000244);
   a_data[2] =  ((float)((int16_t)(((data_bytes[5]*256) + (data_bytes[6])))>> 2) * 0.000244);
   
 }

 void FXOS8700::acquire_mag_data_uT(float * m_data)
 {
  
   char data_bytes[7];
   char d[1];
   d[0]=FXOS8700_MDR_STATUS;
   accelmagi2c.write(FXOS8700_I2C_ADDRESS,d,1,true);  // Read the 6 data bytes - LSB and MSB for X, Y and Z Axes.
   accelmagi2c.read(FXOS8700_I2C_ADDRESS,data_bytes,7);
   
   m_data[0] =  (float)((int16_t)((data_bytes[1]*256) + (data_bytes[2]))) * 0.1;
   m_data[1] =  (float)((int16_t)((data_bytes[3]*256) + (data_bytes[4]))) * 0.1;
   m_data[2] =  (float)((int16_t)((data_bytes[5]*256) + (data_bytes[6]))) * 0.1;
   
 }
     
     