#include "mbed.h"
#include "MPU9250.h"

AnalogIn   pot(A0);
PwmOut myservo(D6);
DigitalOut LedNorma(D2), LedVolante(D3), LedAsa(D4), LedAcelera(D5), myled1(LED1);


float sum = 0;
uint32_t sumCount = 0;

float axf=0, ayf=0, azf=0, soma=0, naxf=0, norma=0, norma2=0, g=0, pr[10];
int Flag_botao=0, Flag_naxf=0,Flag_Norma=0, Flag_axf=0, Flag_DRS=0, Flag_vs=0, Flag_Volante=1, i;

char serial;
bool inicio = true;

Timer t;

MPU9250 mpu9250;

Serial pc(USBTX, USBRX); // tx, rx

volatile bool newData = false;

InterruptIn isrPin(D12);   //k64 D12  dragon PD_0

void mpuisr(){
    newData=true;
}

int main(){
    
    pc.baud(9600);

    //Set up I2C
    i2c.frequency(400000); 
    t.start();
    isrPin.rise(&mpuisr);
    
    myservo.period_ms(20);
    myservo.pulsewidth_ms(1.5);
                 
    uint8_t whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);  // numero registro I2C MPU9250

    if (whoami == 0x73){
        wait(1);
        mpu9250.resetMPU9250(); // Reset registradores
        mpu9250.calibrateMPU9250(gyroBias, accelBias); // calibração giroscopio e acelerometro
        wait(2);
        mpu9250.initMPU9250();
        mpu9250.initAK8963(magCalibration); // Calibração magnetometro
        wait(2);
    }else{
        while(1) // loop de não comunicação
            pc.printf("FAIL!\n");
    }

    mpu9250.getAres(); // valor setado de sensibilidade
    mpu9250.getGres(); 
    mpu9250.getMres();
    magbias[0] = +470.;  // User environmental x-axis correction in milliGauss, should be automatically calculated
    magbias[1] = +120.;  // User environmental x-axis correction in milliGauss
    magbias[2] = +125.;  // User environmental x-axis correction in milliGauss

    while(1) {  
        static int readycnt=0;
#if USE_ISR
        if(newData) {
            newData=false;
            mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS);  //? need this with ISR
#else
            if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) {
#endif
                readycnt++;
                mpu9250.readAccelData(accelCount);  // Read the x/y/z
                ax = (float)accelCount[0]*aRes - accelBias[0];  // Calculo da aceleração - mg
                ay = (float)accelCount[1]*aRes - accelBias[1];
                az = (float)accelCount[2]*aRes - accelBias[2];
                
                mpu9250.readGyroData(gyroCount);  // Read the x/y/z adc values
                gx = (float)gyroCount[0]*gRes - gyroBias[0];  // calculo do giroscopio - rad/s
                gy = (float)gyroCount[1]*gRes - gyroBias[1];
                gz = (float)gyroCount[2]*gRes - gyroBias[2];
                            
                mpu9250.readMagData(magCount);  // Read the x/y/z adc values
                mx = (float)magCount[0]*mRes*magCalibration[0] - magbias[0];  //calculo do magnetometro
                my = (float)magCount[1]*mRes*magCalibration[1] - magbias[1];
                mz = (float)magCount[2]*mRes*magCalibration[2] - magbias[2];
            }

            Now = t.read_us();
            deltat = (float)((Now - lastUpdate)/1000000.0f) ; // set integration time by time elapsed since last filter update
            lastUpdate = Now;
                  
            sum += deltat;
            sumCount++;
                          
            uint32_t us = t.read_us();
            mpu9250.MadgwickQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f,  my,  mx, mz);
            us = t.read_us()-us;
                
            // Serial print and/or display at 0.5 s rate independent of data rates
            delt_t = t.read_ms() - count;
                            
                            
            if (delt_t > 100) { //taxa de atualização calculos - ms
                readycnt=0;
                tempCount = mpu9250.readTempData();  // Read the adc values
                temperature = ((float) tempCount) / 333.87f + 21.0f; // Temperature in degrees Centigrade

                yaw   = atan2(2.0f * (q[1] * q[2] + q[0] * q[3]), q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3]);
                pitch = -asin(2.0f * (q[1] * q[3] - q[0] * q[2]));
                roll  = atan2(2.0f * (q[0] * q[1] + q[2] * q[3]), q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3]);
                pitch *= 180.0f / PI;
                yaw   *= 180.0f / PI;
                yaw   -= 21.1f; // Declination em São carlos (27/06/19)
                roll  *= 180.0f / PI;

                float angle = pot.read()*3600;
                pc.printf("ax: %f\n", ax);
                pc.printf("ay: %f\n", ay);
                pc.printf("az: %f\n\n", az);
                
                
            }
        }    
    
}

     
         