#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "SRF05.h"
#include "logo.h"



/*
   COULEURS CABLES
    5V : cable bleu
    ECHO : cable jaune
    TRIGGER : cable marron
    -- NO CONNEXION --
    GND : cable marron
*/


SRF05 broches (PA_0, PF_9); // assignations des broches
DigitalOut led(LED1);

void drawImageLogo(int offsetX, int offsetY);

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    float mesures, milli, feet;

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    HAL_Delay(1000);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    HAL_Delay(1000);
    BSP_LCD_SetFont(&Font12);
    //BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    

    while(1) {
        
         // affichage des mesures dans le LCD
      mesures = broches.read();
      BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
      BSP_LCD_SetFont(&Font20);
      sprintf((char*)text, "valeur de la distance : %5.3f cm", mesures); 
      BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)&text, LEFT_MODE); 
      led = 0;

      //affichage des alertes
      BSP_LCD_SetTextColor(LCD_COLOR_RED);
      
       if(mesures < 9.0){
            BSP_LCD_SetFont(&Font16);
            sprintf((char*)text, "ATTENTION, RISQUE DE COLUSION");
            BSP_LCD_DisplayStringAt(0, LINE(9), (uint8_t *)&text, CENTER_MODE);
            led = 1; // allume la led
        }else if (mesures > 25.0) {
            BSP_LCD_SetFont(&Font16);
            sprintf((char*)text, "ATTENTION, ELOIGNEMENT       ");
            BSP_LCD_DisplayStringAt(0, LINE(9), (uint8_t *)&text, CENTER_MODE);
        }else{
            BSP_LCD_SetFont(&Font16);
            sprintf((char*)text, "TOUT VA BIEN                 ");
            BSP_LCD_DisplayStringAt(0, LINE(9), (uint8_t *)&text, CENTER_MODE);
            
            }
          
          
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    BSP_LCD_ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                BSP_LCD_DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);     
            }
            
             if ((x>=1&&x<=475)&&(y>=1&&y<=270))
                    {
                        milli = mesures*10.0;
                        BSP_LCD_SetFont(&Font20);
                        sprintf((char*)text, "valeur en millimetres : %5.3f mm", milli);
                        BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)&text, LEFT_MODE);
                        feet = mesures / 30.48;
                        sprintf((char*)text, "valeur en feet : %5.3f ft", feet);
                        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)&text, LEFT_MODE);
                         
                    }  

            BSP_LCD_DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_RED);
        } else {
            if (!cleared) {
                BSP_LCD_Clear(LCD_COLOR_GREEN);
                drawImageLogo(320,0); // affichage du logo en haut à gauche
                sprintf((char*)text, "Touches: 0");
                BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
                cleared = 1;
            }
        }
    }
}

// fonction pour le logo

void drawImageLogo(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)logo.data;
    while(y < logo.height)
    {
        while(x < logo.width)
        {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

