#include "mbed.h"
#include "SDFileSystem.h"
#include "motordriver.h"
#include "Speaker.h"
#include <string>
Motor  right(p21, p22, p23, 1); // pwm, fwd, rev, has brake feature
Motor left(p26, p25, p24, 1);
Speaker mySpeaker(p18);
DigitalIn Enc1(p19); //right motor
DigitalIn Enc2(p20); //left motor
Ticker Sampler; //Interrupt Routine to sample encoder ticks.
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX, USBRX);
Serial esp(p13, p14); // tx, rx
// Standard Mbed LED definitions
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);
int oldEnc1 = 0; //Was the encoder previously a 1 or zero?
int oldEnc2 = 0;
int ticksR = 0; //How many times has the Right wheel encoder changed state? 
int ticksL = 0; //Same for left wheel
int E; // the error  between the 2 wheel speeds
float speedL =0; //PWM speed setting for left wheel (scaled between 0 and 1)
float speedR=0; //Same for right wheel
unsigned char Instr = 0;//What button was sent from app?
unsigned char sentSpeed = 0; //What is the speed slider set to?
// things for sending/receiving data over serial
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 4095;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();
int DataRX;
int update;
int count;
int start_path;
char cmdbuff[1024];
char replybuff[8192];
char webdata[8192]; // This may need to be bigger depending on WEB browser used
char webbuff[8192];     // Currently using 1986 characters, Increase this if more web page data added
char timebuf[30];
char rx_line[1024];
int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.
struct tm t;

// helper function declarations
int charToNum(char);
void SendCMD(),getreply(),ReadWebData(),startserver(),parsedata();sampleEncoder(); //Function for sampling and adjusting speeds. 


int main()
{
    pc.printf("ResetingSD Card!\n");   
   
    FILE *fp = fopen("/sd/path.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fclose(fp); 
    /// MOTOR STUFF
    Sampler.attach(&sampleEncoder, .02); //Sampler uses sampleEncoder function every 20ms

    Enc1.mode(PullUp); // requires a pullup resistor so i just used embed's feature.
    Enc2.mode(PullUp);
    /// WIFI STUFF
    pc.baud(9600);
    esp.baud(9600);
    led1=1,led2=0,led3=0, led4=0;
    // Setup a serial interrupt function to receive data
    esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    esp.attach(&Tx_interrupt, Serial::TxIrq);
    startserver();
    DataRX=0;
    count=0;
    start_path = 0;
    while(1) {
        if(DataRX==1) {
            ReadWebData();
            esp.attach(&Rx_interrupt, Serial::RxIrq);
        }
        if(update==1) 
        {
            SendCMD();
            getreply();
            update=0;   
        }
        if(start_path==1){// If data sent Start parsing data while running robot
            parsedata();
        }
    }
}
// convert an ASCII character of a number to the number it represents (NOT the ascii code of the number)
// ex: '2' -> 2.
int charToNum(char c) {
    return (int) (c - '0');    
}

// Reads and processes GET and POST web data
void ReadWebData()
{
    FILE *fp = fopen("/sd/path.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fclose(fp); 
    wait_ms(200);
    esp.attach(NULL,Serial::RxIrq);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    strcpy(webdata, rx_buffer);
    memset(rx_buffer, '\0', sizeof(rx_buffer));
    rx_in = 0;
    rx_out = 0;
    // check web data for form information write  info to sd card
    if( strstr(webdata, "d1=") != NULL ) {
        led2=!led2;
        pc.printf(strstr(webdata, "d1"));
        string dirs = strstr(webdata, "d1");
        string str2, str3;
        size_t pos;
        pos = dirs.find("stop")-2;    // position of "stop" in str
        str3 = dirs.substr (3,pos);   // get from "stop" to the end
        const char *mycharp = str3.c_str();
        pc.printf(mycharp);
        fp = fopen("/sd/path.txt", "a"); //Open "speedlog.txt" on the local file system for appending ('a' switch)
        fprintf(fp,mycharp); //write value and newline
        fclose(fp); //close file
        start_path = 1;
    }
    if( strstr(webdata, "POST") != NULL ) { // set update flag if POST request
        update=1;
    }
    if( strstr(webdata, "GET") != NULL && strstr(webdata, "favicon") == NULL ) { // set update flag for GET request but do not want to update for favicon requests
        update=1;
    }

}
// Starts webserver
void parsedata(){
    pc.printf("\n");
    pc.printf("+++++++++ROBOT+RUNNING\n");
    unsigned char m;
    const char f= 'f';
    const char l= 'l';
    const char r='r';
    const char b='b';
    const char stop='s';
    int dur;
    
    
    FILE *fp = fopen("/sd/path.txt", "r");
    while (!feof(fp)){
    dur = 0;
    m=fgetc(fp);
    if (m==f){
        dur = charToNum(fgetc(fp));
        pc.printf("Forward for %i seconds\n",dur);
        speedL = float(100) / 100;
        speedR = speedL;
        left.speed(speedL);
        right.speed(speedR);
        Instr = 1;
    }
    if (m==b){
        dur = charToNum(fgetc(fp));
        pc.printf("Backward for %i seconds\n",dur);
        speedL = -float(50) / 100;
        speedR = speedL;
        left.speed(speedL);
        right.speed(speedR);
        Instr = 2;
    }
    if (m==r){
        dur = charToNum(fgetc(fp));
        pc.printf("Right for %i seconds\n",dur);
        speedL = float(50) / 100;
        left.speed(speedL);
        right.speed(-speedL);
    }
    if (m==l){
        dur = charToNum(fgetc(fp));
        pc.printf("Left for %i seconds\n",dur);
        speedL = float(50) / 100;
        left.speed(-speedL);
        right.speed(speedL);
    }
    if (m==stop){
        printf("WOOT \n");
        pc.printf("Putting on the Brakes\n");
        left.speed(0);
        right.speed(0);
        mySpeaker.PlayNote(440.0, 0.5, 0.5);
    }
    if(Instr == 1 || Instr == 2) { // Only increment tick values if moving forward or reverse
            if(Enc1 != oldEnc1) { // Increment ticks every time the state has switched. 
                ticksR++;
                oldEnc1 = Enc1;

            }
            if(Enc2 != oldEnc2) {
                ticksL++;
                oldEnc2 = Enc2;
            }
    }
    wait(dur);
    left.speed(0);
    right.speed(0);
    wait(.1);
    }
    fclose(fp); //close file
    update=0;
    start_path=0;
    }


void sampleEncoder()
{
    if((Instr == 1 || Instr == 2) && ticksL != 0) { //Make sure the robot is moving forward or reversed and that left wheel hasn't stopped. 

        E = ticksL - ticksR; //Find error
        speedR = speedR + float(E) / 255.0f; //Assign a scaled increment to the right wheel based on error
        if(Instr == 1) speedR = speedR + float(E) / 255.0f;
        right.speed(speedR);
    }
    ticksR = 0; //Restart the counters
    ticksL = 0;
}

void startserver()
{

    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"node.restart()\r\n");
    SendCMD();
    wait(2);
    getreply();
    
    pc.printf("\n++++++++++ Starting Server ++++++++++\r\n> ");


    //create server
    sprintf(cmdbuff, "srv=net.createServer(net.TCP,%d)\r\n",SERVtimeout);
    SendCMD();
    getreply();
    wait(0.5);
    strcpy(cmdbuff,"srv:listen(80,function(conn)\r\n");
    SendCMD();
    getreply();
    wait(0.3);
        strcpy(cmdbuff,"conn:on(\"receive\",function(conn,payload) \r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        //print data to mbed
        strcpy(cmdbuff,"print(payload)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
       
        //web page data
        strcpy(cmdbuff,"conn:send('<!DOCTYPE html><html><body><h1>ESP8266 Mbed IoT Web Controller</h1>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        
        strcpy(cmdbuff,"conn:send('<form method=\"POST\"')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p>Directions:<input type=\"text\" name=\"d1\" value=\"f2l3f1stop\">')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff,"conn:send('<p><input type=\"submit\" value=\"send-refresh\"></form>')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        strcpy(cmdbuff, "conn:send('<p><h2>How to use:</h2><ul><li>Build path in basedon value form</li><li>Click Send-Refresh to send data and refresh values</li></ul></body></html>')\r\n");
        SendCMD();
        getreply();
        wait(0.5); 
        // end web page data
        strcpy(cmdbuff, "conn:on(\"sent\",function(conn) conn:close() end)\r\n"); // close current connection
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "end)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
    strcpy(cmdbuff, "end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);

    strcpy(cmdbuff, "tmr.alarm(0, 1000, 1, function()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "if wifi.sta.getip() == nil then\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "print(\"Connecting to AP...\\n\")\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "else\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "ip, nm, gw=wifi.sta.getip()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"print(\"IP Address: \",ip)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"tmr.stop(0)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    
    pc.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
}


// ESP Commands 
void SendCMD()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Get Command and ESP status replies
void getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}
 
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}
 
 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    DataRX=1;
    //led3=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = esp.getc();
// Uncomment to Echo to USB serial to watch data flow
        pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    //led3=0;
    return;
}
 
 
// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((esp.writeable()) && (tx_in != tx_out)) {
        esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    //led2=0;
    return;
}