/* NixieTube.h */
#ifndef NIXIETUBE_H_
#define NIXIETUBE_H_

#include "mbed.h"
class NixieTube 
{
    public:
        NixieTube(PinName,PinName,PinName,PinName);
        ~NixieTube();
        void update_individual_nixie_tube(int,int);
        void update_all_nixie_tube(int,int,int,int);
        void set_dim(float);
        void debug_digits();
    private:
        DigitalOut _sdi;
        DigitalOut _scl;
        DigitalOut _rcl;
        PwmOut _cen;
        int curr_tube;
        volatile int digit1;
        volatile int digit2;
        volatile int digit3;
        volatile int digit4;
        uint32_t delay1;
        uint32_t delay2;
        float brightness;
        
        void nixie_shiftout();
        int nixie_id_convert(int);
        void send_nixie_shiftreg(int, int, int);
        
        Ticker      tickSeq;
};

#endif /* NIXIETUBE_H_ */
 
