#include "NixieTube.h"
/* Not Currently Implmented 
#define TUBE_1_LED 0x00800 
#define TUBE_2_LED 0x01000
#define TUBE_3_LED 0x02000
#define TUBE_4_LED 0x04000
#define TUBE_5_LED 0x08000
#define TUBE_6_LED 0x10000
*/
#define TUBE_1_CATH 0x20000
#define TUBE_2_CATH 0x40000
#define TUBE_3_CATH 0x80000
#define TUBE_4_CATH 0x100000
#define TUBE_5_CATH 0x200000
#define TUBE_6_CATH 0x400000

NixieTube::NixieTube(PinName sdi, PinName scl, PinName rcl, PinName cen): _sdi(sdi), _scl(scl), _rcl(rcl), _cen(cen){
        digit1 = 1;
        digit2 = 2;
        digit3 = 3;
        digit4 = 4;
        curr_tube = 1;
        _cen.period_us(1000);
        _cen.write(1.0);
        std::printf("Starting Object\r\n");
        tickSeq.attach(this, &NixieTube::nixie_shiftout, 0.001 );
        std::printf("Sucess Ticker Started\r\n");
}

NixieTube::~NixieTube()
{
}
 
void NixieTube::nixie_shiftout() {
              
        switch (curr_tube) {
            case 1:
                send_nixie_shiftreg(nixie_id_convert(digit1), 0, TUBE_1_CATH);
                break;
            case 2:
                send_nixie_shiftreg(nixie_id_convert(digit2), 0, TUBE_2_CATH);
                break;
            case 3:
                send_nixie_shiftreg(nixie_id_convert(digit3), 0, TUBE_3_CATH);
                break;
            case 4:
                send_nixie_shiftreg(nixie_id_convert(digit4), 0, TUBE_4_CATH);
                break;
            default:
                curr_tube = 1;
        }
        curr_tube++;
        if (curr_tube == 5) {
            curr_tube = 1;
        }
}
 
int NixieTube::nixie_id_convert(int digit) {
    if (digit == 0 || digit == -1) {
        return digit + 1;  
    }
    if (digit < 10) {
        return 11 - digit;
    }
    if (digit == 10) {
        return 11;
    }
    return 0;
}
 
void NixieTube::send_nixie_shiftreg(int cathode_id, int led_bitfield, int tube_bitfield) {
 
    int buffer = 0;
    buffer = 1 << (cathode_id-1) | led_bitfield | tube_bitfield;
 
    for (int i=23; i >= 0; i--) {
        _sdi = buffer & (1 << i);
        _scl = 1;
        _scl = 0;
    }
    _rcl = 1;
    _rcl = 0;
 
}
void NixieTube::update_individual_nixie_tube(int ref,int val){
    switch(ref){
    case(1):
    digit1 = val;
    case(2):
    digit2 = val;
    case(3):
    digit3 = val;
    case(4):
    digit4 = val;
    } 
}

void NixieTube::update_all_nixie_tube(int val4,int val3,int val2,int val1){
    digit1 = val1;
    digit2 = val2;
    digit3 = val3;
    digit4 = val4;
    } 
void NixieTube::set_dim(float duty){
    _cen.write(duty);
}   
void NixieTube::debug_digits(){
    std::printf("Tube1: %d,Tube2: %d,Tube3: %d,Tube4: %d\r\n",digit1,digit2,digit3,digit4);
    }
