
//cpp file van servo class, alle functies worden hier uitgevoerd
//de servos hebben een effectieve 110 graden om te gebruiken,
//hierdoor hebben we de servos zo geprogrammeerd dat ze maar 90 graden hoeven te gebruiken,
//in plaats van 180 graden
//de servos moeten tegen elkaar in draaien om niet te verplaatsen
//2 servos staan dus altijd in de "90 graden" positie en de andere in de "0 graden" positie
//als we ze draaien worden ze precies andersom gedraaid


#include "mbed.h"
#include "servo.h"  //include de header file waar de functies zijn gedeclareerd

Servo::Servo(int tempcenteroffset, int tempninetyoffset, char tempdirection, PinName pin) : _pwm(pin){  //bind de pin aan een pwm pin
    centeroffset = tempcenteroffset;                //sla de offset 0 graden op
    ninetyoffset = tempninetyoffset;                //sla de offset van 90 graden op
    direction = tempdirection;                      //sla op welke richting ze moeten draaien
    _pwm.period_ms(20);                             //zet de period
}
    
void Servo::servoCenter(){                          //de servo op "0" graden draaien
    if(direction == 'R'){                           //moet de servo rechtsom draaien
        _pwm.pulsewidth_us(ZERO+centeroffset);      //zet de servo naar 0 + offset graden
    }
    if(direction == 'L'){                           //moet de servo linksom draaien
        _pwm.pulsewidth_us(NINETY+centeroffset);    //zet de servo naar 90 + offset graden 
    }
}

void Servo::turnRight(){                            //de servo naar 90 graden draaien
    if(direction == 'R'){                           //moet de servo rechtsom draaien
        _pwm.pulsewidth_us(NINETY+ninetyoffset);    //zet de servo naar de 90 + offset graden
    }
    if(direction == 'L'){                           //moet de servo linksom draaien
        _pwm.pulsewidth_us(ZERO+ninetyoffset);      //zet de servo naar 0 + offset graden
    }
}