#ifndef __S3003_H_
#define __S3003_H_

#include "mbed.h"

#define SERVO_PWM_MSEC              0.030f  // サーボの周期

#define ARM_MOUTH_PWM_WIDTH_MAX     3000    // PWM(最大値)
#define ARM_MOUTH_PWM_WIDTH_CENTER  1750    // PWM(中心)
#define ARM_MOUTH_PWM_WIDTH_MIN      500    // PWM(最小値)

#define PWM_SIG_HI                     1    // シグナルHi
#define PWM_SIG_LO                     0    // シグナルLo

#define SERVO_PWM_MAX_VALUE         3000    // PWM(最大値)
#define SERVO_PWM_MIN_VALUE          500    // PWM(最小値)


// サーボモータ(型式:S3003、FUTABA製)の制御クラス
class S3003
{
    public:
        S3003(PinName pin);
        
    private:
        // Servo Out
        DigitalOut _servo;
        int servoPwmWidth;
        Ticker tm;
        void SetPWM(int pwm_us);
        void PeriodicProcess();
};

#endif