//
#include "mbed.h"
#include "S3003.h"

// ASV15MG
S3003::S3003(PinName pin)
    :_servo(pin)
{
    // 周期割り込みによるPWMの作成
    tm.attach(this,&S3003::PeriodicProcess,SERVO_PWM_MSEC);
    // 初期設定(中心値に設定)
    SetPWM(ARM_MOUTH_PWM_WIDTH_CENTER);
}
// End of S3003


//==================================
// PWM値の設定(Min:750,Max:1850)
// 許容値外の場合は前回値保持
//==================================
void S3003::SetPWM(int pwm_us)
{
    // 範囲外の場合、前回値とする
    if(pwm_us < SERVO_PWM_MIN_VALUE){return;}
    if(pwm_us > SERVO_PWM_MAX_VALUE){return;}
    servoPwmWidth = PWM_SIG_LO;
}
// End of SwtPWM


//==================================
// 周期割り込み処理
//==================================
void S3003::PeriodicProcess()
{
    _servo = PWM_SIG_HI;
    wait_us(servoPwmWidth);
    _servo = PWM_SIG_LO;
}
// End of PeriodicProcess
