#ifndef _MOTER_H_
#define _MOTER_H_

#include "mbed.h"

#define SPEED_BUFF 0

#define SPEED_SLOW_MOVE 30

#define ARM_SERVO_DOWN      2300
#define ARM_SERVO_UP        1420

#define MODE_F    0
#define MODE_RF   1
#define MODE_R    2
#define MODE_RB   3
#define MODE_B    4
#define MODE_LB   5
#define MODE_L    6
#define MODE_LF   7
#define MODE_STOP 10

#define STARTUP_MODE        0
#define RUN_MODE            1
#define BONUS_MODE          2
#define STOP_MODE           3


#define DIRECTION_PATTERN_NUM 8 //進行方向のパターン数


#define MOTOR_RF_FRONT 1620 - SPEED_BUFF
#define MOTOR_RF_STOP  1520
#define MOTOR_RF_BACK  1430 + SPEED_BUFF

#define MOTOR_RB_FRONT 1630 - SPEED_BUFF
#define MOTOR_RB_STOP  1520
#define MOTOR_RB_BACK  1430 + SPEED_BUFF

#define MOTOR_LB_FRONT 1640 - SPEED_BUFF
#define MOTOR_LB_STOP  1525
#define MOTOR_LB_BACK  1420 + SPEED_BUFF

#define MOTOR_LF_FRONT 1625 - SPEED_BUFF
#define MOTOR_LF_STOP  1525
#define MOTOR_LF_BACK  1420 + SPEED_BUFF

#define MOTOR_STOP_FR       1520
#define MOTOR_STOP_BR       1520
#define MOTOR_STOP_BL       1525
#define MOTOR_STOP_FL       1525

#define MOTOR_FRONT_FR            1620
#define MOTOR_FRONT_BR            1630
#define MOTOR_FRONT_BL            1640
#define MOTOR_FRONT_FL            1625

#define MOTOR_BACK_FR             1453
#define MOTOR_BACK_BR             1397
#define MOTOR_BACK_BL             1398
#define MOTOR_BACK_FL             1420


#define MOTOR_FRONT_FR_200            1680// 1620
#define MOTOR_FRONT_BR_200            1700// 1630
#define MOTOR_FRONT_BL_200            1720// 1640
#define MOTOR_FRONT_FL_200            1700// 1625

#define MOTOR_BACK_FR_200             1400 //1453
#define MOTOR_BACK_BR_200             1325 //1397
#define MOTOR_BACK_BL_200             1350 //1398
#define MOTOR_BACK_FL_200             1360 //1420


#define MOTOR_FRONT_RIGHT_FR       1480
#define MOTOR_FRONT_RIGHT_BR       MOTOR_FRONT_BR_200//1630
#define MOTOR_FRONT_RIGHT_BL       1565
#define MOTOR_FRONT_RIGHT_FL       MOTOR_FRONT_FL_200//1625

#define MOTOR_FRONT_LEFT_FR        MOTOR_FRONT_FR_200//1620
#define MOTOR_FRONT_LEFT_BR        1570
#define MOTOR_FRONT_LEFT_BL        MOTOR_FRONT_BL_200//1640
#define MOTOR_FRONT_LEFT_FL        1485

#define MOTOR_RIGHT_FR             MOTOR_BACK_FR_200//1453           
#define MOTOR_RIGHT_BR             MOTOR_FRONT_BR_200//1630
#define MOTOR_RIGHT_BL             MOTOR_BACK_BL_200//1398
#define MOTOR_RIGHT_FL             MOTOR_FRONT_FL_200//1625

#define MOTOR_LEFT_FR              MOTOR_FRONT_FR_200//1620
#define MOTOR_LEFT_BR              MOTOR_BACK_BR_200//1397
#define MOTOR_LEFT_BL              MOTOR_FRONT_BL_200//1640
#define MOTOR_LEFT_FL              MOTOR_BACK_FL_200//1420

#define MOTOR_BACK_RIGHT_FR       MOTOR_BACK_FR_200//1430
#define MOTOR_BACK_RIGHT_BR       1555
#define MOTOR_BACK_RIGHT_BL       MOTOR_BACK_BL_200//1420
#define MOTOR_BACK_RIGHT_FL       1495

#define MOTOR_BACK_LEFT_FR        1480
#define MOTOR_BACK_LEFT_BR        MOTOR_BACK_BL_200//1430
#define MOTOR_BACK_LEFT_BL        1560
#define MOTOR_BACK_LEFT_FL        MOTOR_BACK_FL_200//1420

#define FLAG_ON             1
#define FLAG_OFF            0
//2回連続でゴール判定をした場合にゴールと認識する(誤認識対策)
#define GOAL_DELAY         80

extern unsigned short runMode;
extern void moveStop();

extern void moveF();
extern void moveFR();
extern void moveFL();
extern void moveL();
extern void moveR();
extern void moveBR();
extern void moveBL();
extern void moveB();
extern bool IsLine(unsigned char data ,int i);
extern int setMove(char cSensorData);
extern void ReverseMove(int mode);
static int mode_before;

extern void ArmUp();
extern void ArmDown();

extern void BonusTime();

#endif
