#ifndef __ASV15MG_H_
#define __ASV15MG_H_

#include "mbed.h"

#define SERVO_PWM_MSEC              0.020f  // サーボの周期

#define ARM_MOUTH_PWM_WIDTH_MAX     1850    // PWM(最大値)
#define ARM_MOUTH_PWM_WIDTH_CENTER  1300    // PWM(中心)
#define ARM_MOUTH_PWM_WIDTH_MIN      750    // PWM(最小値)

#define PWM_SIG_HI                     1    // シグナルHi
#define PWM_SIG_LO                     0    // シグナルLo

#define SERVO_PWM_MAX_VALUE         1850    // PWM(最大値)
#define SERVO_PWM_MIN_VALUE          750    // PWM(最小値)


// サーボモータ(ASV-15MG)の制御クラス
class ASV15MG
{
    public:
        ASV15MG(PinName pin);
        
    private:
        // Servo Out
        DigitalOut _servo;
        int servoPwmWidth;
        Ticker tm;
        void SetPWM(int pwm_us);
        void PeriodicProcess();
};

#endif