#include "mbed.h"
#include "QEI.h"

const float M_PI = 3.14159265358979323846;

Serial pc(USBTX, USBRX);
Ticker flipper1;

Timer timer;

const int PPR = 1024;
const int gear_ratio = 126; 
//const float Sampling_time1 = 0.0005;
const float Sampling_time1 = 0.01;

QEI encs[6] = {
     QEI(PD_12,  PA_15, NC, PPR, &timer),
     QEI(PD_3,  PB_6, NC, PPR, &timer),
     QEI(PB_10, PB_4, NC, PPR, &timer),//, QEI::X4_ENCODING),
     QEI(PH_1,  PC_0, NC, PPR, &timer),
     QEI(PG_2,  PC_7, NC, PPR, &timer),
     QEI(PB_5,  PD_13, NC, PPR, &timer),
};

void flip1() {
    for(int i=0;i<6;i++)
        pc.printf("%f\n",encs[i].getAngle());
    pc.printf("\n");
}

int main() {
    pc.baud(115200);
    flipper1.attach(&flip1, Sampling_time1);
    
    while(1){
        //pc.printf("%f, %f, %f, %f, %f, %f\n", float(Pulses1), Angle1, Angular_velocity1, float(Pulses2), Angle2, Angular_velocity2);
    }
}
