#include "Led.h"


extern LCD_DISCO_F429ZI LCD_Display;

Led::Led(unsigned char ucColumnNr, unsigned char ucRowNr){
    LCD_Display.Clear(LCD_COLOR_BLACK);
    LCD_Display.SetBackColor(LCD_COLOR_RED);
    LCD_Display.SetFont(&Font24); 
    ucColumn=ucColumnNr;
    ucRow=ucRowNr;
    
    Off();
}   

void  Led::Redraw(uint32_t Color){
    LCD_Display.SetTextColor(LCD_COLOR_GREEN);  
    LCD_Display.DrawRect((80*ucColumn) ,ucRow*80,80,80);
    LCD_Display.SetTextColor(Color);
    LCD_Display.FillRect(1+80*ucColumn , 1+ucRow*80, 79, 79);
    
    LCD_Display.SetTextColor(LCD_COLOR_RED);
    LCD_Display.FillRect(80*ucColumn, ucRow*80, 20, 25);
    LCD_Display.SetTextColor(LCD_COLOR_WHITE);
    char cDisplay[2];
    sprintf(cDisplay, "%d", ucRow);
    LCD_Display.DisplayStringAt(2+80*ucColumn, 2+ucRow*80,(uint8_t *) cDisplay, LEFT_MODE);
}
 

void Led::On(){
    Redraw(LCD_COLOR_GREEN);
}     
    
void Led::Off(){
    Redraw(LCD_COLOR_BLUE);
}
      