#include "Led_Lcd.h"
#define MAX_DISPLAY_NUMBER 3

LedLcd::LedLcd(unsigned char ucColumn){
    LCD_Display.Clear(LCD_COLOR_BLACK);
    LCD_Display.SetBackColor(LCD_COLOR_RED);
    LCD_Display.SetFont(&Font24); 
    uiColumnNumber=ucColumn;
    
    On(4);
    }   

void  LedLcd::DrawKey(unsigned char ucKeyNumber){
    LCD_Display.SetTextColor(LCD_COLOR_GREEN);  
    LCD_Display.DrawRect((80*uiColumnNumber) ,ucKeyNumber*80,80,80);
    LCD_Display.SetTextColor(uiColor[ucKeyNumber]);
    LCD_Display.FillRect(1+80*uiColumnNumber , 1+ucKeyNumber*80, 79, 79);
    
    LCD_Display.SetTextColor(LCD_COLOR_RED);
    LCD_Display.FillRect(80*uiColumnNumber, ucKeyNumber*80, 20, 25);
    LCD_Display.SetTextColor(LCD_COLOR_WHITE);
    char cDisplay[MAX_DISPLAY_NUMBER];
    sprintf(cDisplay, "%d", ucKeyNumber);
    LCD_Display.DisplayStringAt(2+80*uiColumnNumber, 2+ucKeyNumber*80,(uint8_t *) cDisplay, LEFT_MODE);
}
 

void LedLcd::On(unsigned char ucKeyNumber){
    uint8_t CurrentKey;
    for(CurrentKey=0; CurrentKey<NUMBER_OF_KEYS; CurrentKey++){
        if(CurrentKey==ucKeyNumber){
            uiColor[CurrentKey]=LCD_COLOR_GREEN;
            }
        else{
            uiColor[CurrentKey]=LCD_COLOR_BLUE;
            }
        DrawKey(CurrentKey);
        }
    }     
    