#include "mb_pins.h"
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"

#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"

#include <string> 
using namespace std;

///////////////////////////////////////////////////////////////

#define SMALL_WAIT_MS 10
#define VOLTAGE_SCALER 3.3f

//I2C adress
#define I2C_ADDRESS         0x3c
#define I2C_ADD_MBED    I2C_ADDRESS << 1

//OLED DIMENSIONS
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128

///////////////////////////////////////////////////////////////

TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
WiFiInterface *wifi;

I2C i2c_obj(MB_OLED_SDA, MB_OLED_SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);

const char* topic_sub = "subpim";
const char* topic_pub = "pubpim";
const char* hostname = "broker.hivemq.com";
const int port = 1883;

Timer t;
AnalogIn pot1(MB_POT1);

char buf[100];
string s;

string recv;
string tran;

bool oledInit = false;

string chrToStr(char* a, int size){
    string s = "";
        for (int i = 0; i < size; i++) {
            s = s + a[i];
        }
    return s;
}

void updateOLED()
{
    myOLED.clearDisplay();
    myOLED.setTextCursor(0, 0);
    myOLED.printf("Recv: %s\n", recv.c_str());
    myOLED.printf("Tran: %s\n", tran.c_str());
    myOLED.display(); 
}

void printMQTT()
{
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    //message.payloadlen = strlen(buf)+1;
    message.payloadlen = strlen(buf);
    client.publish(topic_pub, message);   
}

void sendValue(){
    sprintf(buf, "V = %1.2f", pot1*VOLTAGE_SCALER);
    s = chrToStr(buf, sizeof(buf));
    tran = s;
    printMQTT();
}

///////////////////////////////////////////////////////////////

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Browser message: %.*s \n", message.payloadlen, (char*)message.payload);
    
    //sprintf(buf, "%.*s %d", message.payloadlen, (char*)message.payload, message.payloadlen);
    //printMQTT();
    
    s = chrToStr((char*)message.payload, message.payloadlen);
    
    recv = s;
    
    //sprintf(buf, "%s", s.c_str());
    //printMQTT();
    
    if(s == "start")
    {
        sendValue();
        t.reset();
        t.start();
    }
    else if(s == "stop")
    {
        t.stop();
    }
    else if(s == "oled")
    {
        oledInit = true;
        myOLED.begin();
        //myOLED.clearDisplay();
        //myOLED.display();
    }
    
}

///////////////////////////////////////////////////////////////

int main()
{
    wifi = WiFiInterface::get_default_instance();
    
    printf("Connecting to %s \n",MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    //if(ret != 0){
    //    printf("Greska u povezivanju");
    //    return -1;
    //}
    printf("Connected\n");
    
    socket.open(wifi);
    socket.connect(hostname,port);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-60";

    client.connect(data);
    client.subscribe(topic_sub, MQTT::QOS0, messageArrived);
    
    i2c_obj.frequency(400000);
    
    while(1) {
        if (t.read() > 10) {
            sendValue();
            t.reset();
        }
        thread_sleep_for(SMALL_WAIT_MS);
        if(oledInit)
            updateOLED();
        client.yield(1000);
    }
}
