/*
Zasto ljudi cudno cuju?
    -Filip Stevanovic

Da bi smo bili bolji predatori, evolucija je coveku razvila veoma osetljiva cula.
Da bi se to ostvarilo, mozak signale sa cula logaritmuje, i tako se promene
na veoma malim nivoima jasno uocavaju dok se promene na velikim nivoima skoro uopste
ne primecuju.

Hvala na paznji

Addendum (Sta se zapravo desava):
Zvuk u buzzeru pravi preklapanje, tj prelazak sa jedinice na nulu i obrnuto. 
Stoga duty cycle nije bitan osim u ekstremnim slucajevima sa mnogo malim i mnogo velikim vrednostima 
gde kapacitivnost zujalice i otpornik paralelan njoj "peglaju" napon pa zujalica ne moze ni da odreaguje.
Van toga, duty cycle pravi promene u zvuku zbog razlicitog tajmiranja preklapanja pa je talasni oblik medjusobno ispomeran.
Sto se tice frekvencije, mi to cujemo logaritamski tj. basove veoma dobro razaznujemo dok veoma visoke frekvencije 
realno samo znamo da ih ima, dok smo najtacniji oko 3.3kHz.
Jacina zvuka (Pitch) se stoga samo svodi na frekvenciju.
*/

#include "mbed.h"

//Constants
#define DebouncePeriod 100    //Period that a button needs to stabilise in miliseconds. 100 should be okay
#define ArbitraryWaitPeriod 1 //Aritrary pooling waiting periods, its should be the in the scale of tens of miliseconds to max 100

//Constants for frequency spectrum function
const int n = 5000;
const int k = -4950;

//Pins
#define A PA_10
#define B PA_9
#define C PA_8
#define D PB_10
#define E PB_5
#define F PB_4
#define G PB_3
#define SEL1 PB_6
#define SEL2 PC_7
#define SW1 PC_9
#define POT1 PA_0
#define POT2 PA_1
#define BUZZ PA_11
#define LD2 PB_15

//Pin/Object declaration
PwmOut buzzer (BUZZ);
DigitalOut led2 (LD2);
InterruptIn sw1 (SW1);
AnalogIn pot1 (POT1);
AnalogIn pot2 (POT2);
BusOut display (A,B,C,D,E,F,G);
BusOut select (SEL2,SEL1);

//Timer declaration
Timer t;

//Global variable for updating the display when SW1 is pressed
int value = 0;

//ISR for Switch1 (Fall)
void ISR_sw1(){
    //If the button recently fell, dont do the ISR again (Debounce)
    //If it didnt, do it and save the new time when you did it
    if(t.read_ms()> DebouncePeriod){
        value = pot1 * 100;
        led2 = !led2;
        t.reset();
    }
}

////////////////////////////////////////////////////////
//Made on last test thus minimal commenting
//Show digit on display
void SegDisp (int num){
    switch(num){
        case 0:display = 0b1000000;break;   
        case 1:display = 0b1111001;break;   
        case 2:display = 0b0100100;break;   
        case 3:display = 0b0110000;break;   
        case 4:display = 0b0011001;break;   
        case 5:display = 0b0010010;break;   
        case 6:display = 0b0000010;break;   
        case 7:display = 0b1111000;break;   
        case 8:display = 0b0000000;break;   
        case 9:display = 0b0010000;break;   
        default:display = 0x7f;    break;
    
    }
}

//Convert number to digits and show on display
void PrintDisp(int num){
    int j = num%10,d = num/10;
    if(d==0)
        SegDisp(-1);
    else
        SegDisp(d);
    select = 0b01;
    wait_ms(ArbitraryWaitPeriod);
    SegDisp(j);
    select = 0b10;
    wait_ms(ArbitraryWaitPeriod);
}
////////////////////////////////////////////////////////

//Main
int main(){
    //Starting timer
    t.start();
    //Binding ISR to fall for Switch1
    sw1.fall(&ISR_sw1);
    
    //Main Loop
    while(1){
        //Pooling Pot1 i Pot2
        buzzer=pot1*0.5f; //Arbitrary division by 2 as it is apsolutely same if duty is .25 or .75
        buzzer.period_us(k*pot2+n); //Linearise  frequency from 20Hz to 20kHz 
        
        //Print Pot1 to Display
        PrintDisp(value); //It never gets to 1 so it wont get to 100 thus its limited to 99
        
        //Pooling time is integrated in PrintDisp function
    }
}

