#include<mbed.h>



//Pinovi
#define A PA_10
#define B PA_9
#define C PA_8
#define D PB_10
#define E PB_5
#define F PB_4
#define G PB_3
#define SEL1 PB_6
#define SEL2 PC_7
#define SW1 PC_9
#define SW2 PC_8

//Vremena
#define HalfPool 1

//Definisanje izlaza
BusOut display (A,B,C,D,E,F,G);
BusOut select (SEL2,SEL1);
DigitalIn Dugme1 (SW1);
DigitalIn Dugme2 (SW2);

//Funkcija za ispisivanje cifre na displej
void SegDisp (int num){
    switch(num){
        case 0:display = 0b1000000;break;   
        case 1:display = 0b1111001;break;   
        case 2:display = 0b0100100;break;   
        case 3:display = 0b0110000;break;   
        case 4:display = 0b0011001;break;   
        case 5:display = 0b0010010;break;   
        case 6:display = 0b0000010;break;   
        case 7:display = 0b1111000;break;   
        case 8:display = 0b0000000;break;   
        case 9:display = 0b0010000;break;   
        default:display = 0x7f;    break;
    
    }
}

//Konvertovanje broja u cifre i ispisivanje
void ispisi(int num){
    int j = num%10,d = num/10;
    if(d==0)
        SegDisp(-1);
    else
        SegDisp(d);
    select = 0b01;
    wait_ms(HalfPool);
    SegDisp(j);
    select = 0b10;
    wait_ms(HalfPool);   
}

//Varijable za pracenje dugmadi i trenutnog broja
int lastDugme1=1,lastDugme2=1;
int lastlastDugme1=1,lastlastDugme2=1;
int brojac=0;

int main(){
    //Default vrednosti za sve ugaseno
    display = 0x7f;
    select = 0x3;
    
    while(1){
        //Ispisivanje
        ispisi(brojac);
        
        //Provera da li je doslo do promene
        if(lastlastDugme1==0 && lastDugme1==0 && Dugme1==1)
            brojac=(brojac+1)%16;
            
        if(lastlastDugme2==0 && lastDugme2==0 && Dugme2==1)
            brojac=(brojac+15)%16;

        //Update stanja
        lastlastDugme1=lastDugme1;
        lastlastDugme2=lastDugme2;
        
        lastDugme1=Dugme1;
        lastDugme2=Dugme2;
        
    }
    
    }