#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <string.h>
#include <stdio.h>
#include <iostream>

#define PORT 80


const char *ip = "192.168.100.1";
const char *mask = "255.255.255.0";
const char *gateway = "192.168.100.1";

Serial pc(USBTX, USBRX);
FILE *fp;
char buffer[1024];

EthernetInterface eth;                                                                                                  //Tworzenie obiektu Ethernet
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");                                                                          //inicjalizacja  czytnika karty SD (MOSI,MISO,SCK,CS)
TCPSocketConnection client;                                                                                             //Tworzenie socketu TCP dla 2 stron (client, server)
TCPSocketServer svr;

bool server_is_listened = false;                                                                                        // Ustawienie defaultowych wartosci flag
bool client_is_connected = false;

void Send_Data_From_SD()
{
    pc.printf("Inicjalizacja... \r\n");
    wait(2);

    fp = fopen("/sd/hello.htm", "r");
    if (fp == NULL) {
        pc.printf("\r\nNie udalo sie odczytac pliku hello.htm.\r\n");
    } else {
        printf("\nOdczytano plik hello.htm z karty SD.\r\n");
        int size = fread(buffer, sizeof(char), 1024, fp);
        printf("Liczba znakow: %d, tekst z pliku hello.htm:\r\n %s \r\n", size, buffer);
        client.send(buffer, 1024);                                                                                      // Wysyłanie danych z odczytanego pliku do clienta TCP co powoduje odpowiednie akcje w przegladarce 
        fclose(fp);
    }
    
    client_is_connected = false;
}
void Initialize_Server(void) 
{
    eth.init(ip,mask,gateway);                                                                                          //Inicjalizacja polaczenia Ethernet, ustawienie statycznego adresu IP
    eth.connect();                                                                                                      //Aktywowanie interfejsu 
    printf("Zainicjowano Ethernet! \r\n");                            
    printf("Adres IP: %s\r\n",eth.getIPAddress());
    printf("Maska: %s\r\n",eth.getNetworkMask());
    printf("Brama: %s\r\n",eth.getGateway());
    printf("Adres MAC urzadzenia: %s\r\n",eth.getMACAddress());
    if (svr.bind(PORT) < 0) 
    {
        printf("Nie udalo sie powiazac serwera TCP z portem 80 (HTTP)! \r\n");
        return;
    }
    else 
    {
        printf("Powiazano serwer TCP z portem 80 (HTTP). \r\n");
        server_is_listened = true;
    }
    
    if (svr.listen(1) < 0) 
    {
        printf("Nie udalo sie rozpoczac nasluchiwania polaczen przychodzacych serwera TCP! \r\n");
        return;
    }
    else 
    {        
        printf("Serwer TCP rozpoczal nasluchiwanie polaczen przychodzacych. \r\n");
    }    
}

int main() 
{
    pc.baud(9600);
    printf("Zainicjowano UART! \r\n");
    printf("Predkosc bitowa transmisji - 9600b/s.\r\n");
    Initialize_Server();
    while (server_is_listened) {
        if (svr.accept(client)) 
        {
            printf("Nie udalo sie zaakceptowac polaczenia z klientem! \r\n");
        }
        else 
        {
            printf("Polaczono z klientem. IP klienta: %s\r\n", client.get_address());
            client_is_connected = true;
            while (client_is_connected)
            {  
                Send_Data_From_SD();
            }
            client.close();
            printf("Wyslano dane do klienta i rozlaczono sesje. \r\n");
        }
    }
}
