//************************Filip Butumović - Diplomski rad br. E504****************************
//*****Realizacija dvopoložajnog regulatora temperature upotrebom mbed mikroupravljača********

#include "mbed.h"
#include "rtos.h"

BusOut Seg1(p12, p11, p10, p9, p8, p7, p6, p5);  //Izlazi segmenata
BusOut Disp1(p30,p29,p28,p27);  //Izlazi pojedinih zaslona
InterruptIn TP1(p24);   //Signal lijeve tipke
DigitalIn TP2(p25); //Signal srednje tipke
DigitalIn TP3(p26); //Signal desne tipke
AnalogIn TempIN(p20);   //Analogni ulaz vrijednosti senzora temperature
Timer uzorkovanje;  //Citanje analognog ulaza s vremenskom odgodom, uzorkovanje
Serial pc(USBTX, USBRX);    //Serijska komunikacija između mikroupravljača i PC-a putem USB sučelja
PwmOut AKT(p21);   //Aktuator (grijac)

char SegConvert(char SegValue);
const int disp[5]= {0x01,0x02,0x04,0x00,0x08};
int menu=0, T1_Temp=0, T2_Temp=0, T3_Temp=0,Temp_SP=0, Temp_DB=0, Temp1=0, Temp2=130, TempIN1=0, TempIN2=1, NumbAct=0,counter=0, i=0,Numb=0, AKT_marker=0,Temp_Act=0;
//Temp_SP - Zadana vrijednost temperature, Temp_DB - Zadana vrijednost tolerancije (Dead-Band), Temp1=x1 (min u rasponu), Temp2=x2(max u rasponu), TempIN1=y1, TempIN2=y2, Temp_Act - Stvarna izmjerena temperatura (skalirana)
float AN_IN_Temp=0; //Varijabla u koju se privremeno sprema vrijednost učitane analogne vrijednosti

int Reference(int Ref);
void MenuSwitch(void);

void funkc_prikaz(void const *argument)//Funkcija za upravljanje prikazom 7 segmentnog zaslona
{
    while(true) {
        TP1.rise(&MenuSwitch); //Pritiskom na lijevo tipku, mjenja se vrsta prikaza na zaslonu
        uzorkovanje.start();
        if (uzorkovanje.read_ms()>=100) {
            AN_IN_Temp=TempIN;
            Temp_Act=Temp1+(((AN_IN_Temp-TempIN1)*(Temp2-Temp1))/(TempIN2-TempIN1));//Jednadzba pravca kroz dvije tocke - skaliranje ulazne vrijednosti temperature
            uzorkovanje.reset();
        }
//pc.printf("Stvarna vrijednost:%f   Skalirana vrijednost:%d  Stanje aktuatora:%d\n\r",AN_IN_Temp, Temp_Act, AKT_marker); //Ispis vrijednosti na terminalu
        if(menu==0) {   //Prikazuje vrijednost stvarne temperature ("A" na zaslonu)
            NumbAct=Temp_Act;
        }
        if(menu==1) {   //Prikazuje vrijednost referentne temperature ("S" na zaslonu)
            Temp_SP=Reference(Temp_SP);
            NumbAct=Temp_SP;
        }
        if(menu==2) {   //Prikazuje vrijednost tolerancije na zaslonu ("d" na zaslonu)
            Temp_DB=Reference(Temp_DB);
            NumbAct=Temp_DB;
        }
        if(NumbAct<10) {    //Ako je broj koji se treba prikazati jednoznamenkasti, upravljanje vrsi ova petlja
            for(i=0; i<2; i++) {
                if(i==0) {
                    Disp1=disp[i];
                    Seg1=SegConvert(NumbAct);
                }
                if(i==1) {
                    Disp1=disp[4];
                    Seg1=SegConvert(menu+11);
                }
                wait(0.001);
            }
        }
        if(NumbAct>=10&&NumbAct<100) {  //Ako je broj koji se treba prikazati dvoznamenkasti, upravljanje vrsi ova petlja
            for(i=0; i<3; i++) {
                if(i<2) {
                    if(i==0) {
                        Numb=NumbAct%10;
                    }
                    if(i==1) {
                        Numb=NumbAct/10;
                    }
                    Disp1=disp[i];
                    Seg1=SegConvert(Numb);
                }
                if(i==2) {
                    Disp1=disp[4];
                    Seg1=SegConvert(menu+11);
                }
                wait(0.001);
            }

        }
        if(NumbAct>=100&&NumbAct<1000) {    //Ako je broj koji se treba prikazati troznamenkasti, upravljanje vrsi ova petlja
            for(i=0; i<4; i++) {
                if(i<3) {
                    if(i==0) {
                        Numb=NumbAct%10;
                    }
                    if(i==1) {
                        Numb=NumbAct/10;
                        Numb=Numb%10;
                    }
                    if(i==2) {
                        Numb=NumbAct/100;
                    }
                    Disp1=disp[i];
                    Seg1=SegConvert(Numb);
                }
                if(i==3) {
                    Disp1=disp[4];
                    Seg1=SegConvert(menu+11);
                }
                wait(0.00075);
            }
        }
    }
}
void MenuSwitch()   //Funkcija za promjenu prikaza na zaslonu, izbornik (0-stvarna temperatura, 1-zadavanje referentne vrijednosti, 2- zadavanje tolerancije
{
    menu=menu+1;
    if(menu>2) {
        menu=0;
    }
}

char SegConvert(char SegValue)  //Funkcija koja dekodira broj za ispravan prikaz na zaslonu 7 segmentnog zaslona
{
    char SegByte=0x00;
    switch(SegValue) {
        case 0 :
            SegByte=0x03;   // Broj 0
            break;
        case 1 :
            SegByte=0x9F;   // Broj 1
            break;
        case 2 :
            SegByte=0x25;   // Broj 2
            break;
        case 3 :
            SegByte=0x0D;   // Broj 3
            break;
        case 4 :
            SegByte=0x99;   // Broj 4
            break;
        case 5 :
            SegByte=0x49;   // Broj 5
            break;
        case 6 :
            SegByte=0x41;   // Broj 6
            break;
        case 7 :
            SegByte=0x1B;   // Broj 7
            break;
        case 8 :
            SegByte=0x01;   // Broj 8
            break;
        case 9 :
            SegByte=0x09;   // Broj 9
            break;
        case 10 :
            SegByte=0xFE;   // Decimalna tocka
            break;
        case 11 :
            SegByte=0x11;   // "A" kao "Actual"
            break;
        case 12 :
            SegByte=0x49;   // "S" kao "Setpoint"
            break;
        case 13 :
            SegByte=0x85;   // "d" kao "Dead Band"
            break;
    }
    return SegByte;
}
int Reference(int Ref)//Funkcija koja generira broj koji se zapisuje u varijablu reference ili tolerancije, ovisno koja ju pozove
{
    counter=Ref;
    if(TP2==0) {
        T2_Temp=0;   //Tipka 2 ako je u "nuli", preslikava se stanje u privremenu memoriju
    }
    if(TP3==0) {
        T3_Temp=0;   //Tipka 3 ako je u "nuli", preslikava se stanje u privremenu memoriju
    }
    if((T2_Temp==0&&TP2==1)||(T2_Temp==1&&TP2==0)) {//Prethodno zapamceno stanje T2 i trenutno stanje tipke T2 ako je razlicito brojac se uvecava za jedan
        counter++;
    }
    if((T3_Temp==0&&TP3==1)||(T3_Temp==1&&TP3==0)) {//Prethodno zapamceno stanje T3 i trenutno stanje tipke T3 ako je razlicito brojac se umanjuje za jedan
        counter--;
    }
    if(counter<=0) {    //Limit minimalnog moguceg broja za odredivanje reference
        counter=0;
    }
    if(counter>=999) {  //Limit maksimalnog moguceg broja za odredivanje reference
        counter=999;
    }
    if(TP2==1) {
        T2_Temp=1;   //Tipka 2 ako je u "jedinici", preslikava se stanje u privremenu memoriju
    }
    if(TP3==1) {
        T3_Temp=1;   //Tipka 3 ako je u "jedinici", preslikava se stanje u privremenu memoriju
    }
    return counter;
}
int main()
{
    Thread petlja2(funkc_prikaz);   //Pozivanje funkcije koja ce se paralelno izvrsavati sa  glavnom funkcijom
    AKT.period(0.01);
    while(1) {
        while((Temp_SP+Temp_DB)>Temp_Act) {     //Glavna petlja - dvopolozajna regulacija. Ako je zadana temperatura veca od stvarne, pali se grijac
            if(AKT_marker==1) {}
            else {
                AKT=0.5;
                AKT_marker=1;
            }
        }
        while((Temp_SP-Temp_DB)<Temp_Act) {     //Glavna petlja - dvopolozajna regulacija. Ako je zadana temperatura manja od stvarne, gasi se grijac
            if(AKT_marker==1) {
                AKT=0;
                AKT_marker=0;
            } else {
            }
        }
    }
}