/**
@file main.h
@brief Header file for Snake, containing functions prototypes and global variables.
@brief Revision 1.0.
@author Fiifi Mills
@date   May 2015
*/

#include "mbed.h"
#include "N5110.h"
#include "PinDetect.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include <vector>
#include <stdlib.h>     /* srand, rand */
#include <time.h>

/**
Enumerated type used for directions read from joystick
*/

enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

DirectionName currentDirection; /*!< DirectionName variable used to refer to the joystick's current direction */
DirectionName previousDirection; /*!< DirectionName variable used to refer to the snake's previous direction */

/**
Enumerated type used to display different game menu screens
*/

enum GameMenu {
    STARTUP,
    SELECTSPEED,
    GAMEPLAY
};

GameMenu currentGameMenu; /*!< GameMenu variable used to refer to the current game menu being displayed */

/**
Struct used for creating coordinates
*/

struct coordinate {
    int x; 
    int y; 
};


/** 
Various flags used in the game for notification of specific events
*/

int printFlag; /*!< print flag set in ISR */
int Aflag;  /*!< Aflag set in ISR when button A pressed */
int Bflag;  /*!< Bflag set in ISR when button B pressed */
int collisionFlag; /*!< collisionflag set in moveSnake() when snake collides with self */
int borderFlag; /*!< borderflag set when snake collides with border in insane mode */

/** 
Global variables
*/

int score; /*!< The score that the user has accumulated throughout the game */
int xCentre; /*!< The x coordinate of the centre of the selection circle used in the SELECTSPEED game menu */
int yCentre; /*!< The y coordinate of the centre of the selection circle used in the SELECTSPEED game menu */
bool gameOver; /*!< Boolean variable signifying whether or not the game is over */
float speed; /*!< The wait time used in the moveSnake function */


/**
Implements the actual game's functionality by moving the snake and checking when certain rules have been broken
*/
void moveSnake();

/**
Moves the selection circle in the SELECTSPEED game menu either up or down depending on the direction in which the joystick is moved
*/
void speedSelect();

/**
Vector that contains coordinate structs, represents the snake in game
*/
std::vector<coordinate> Snake;

