/*
*
*        utils.c functions to work with ethernet frames
*
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <inet.h>
#include "mbed.h"
#include "EthernetNetIf.h"
#include "defines.h"
#include "utils.h"
#include "variables.h"

extern "C" void 
mbed_mac_address(char *mac);

static
void
set_to_mac( char *peth, char const *pmac )
{
    memcpy( peth, pmac, MAC_ADD_NUM );
}

static
void
set_from_mac( char *peth, char const *pmac )
{
    memcpy( peth + MAC_ADD_NUM, pmac, MAC_ADD_NUM );
}

static
void
set_ether_type( char *peth, unsigned ether_type )
{
    unsigned short etype;

    etype = ether_type;
    etype = htons(etype);
    memcpy( peth + 2*MAC_ADD_NUM, &etype, sizeof(unsigned short) );
}
