/*
 *     eth2.c
 *         Send ethernet frames
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <inet.h>
#include "mbed.h"
#include "EthernetNetIf.h"
#include "defines.h"
#include "utils.h"
#include "variables.h"



/*
 *     Public functions
 *         main: here starts ball rolling forever !!!
 */
    
int
main( void )
{
    int i;

    set_to_mac( eth_txs_buffer, broadcast );

    printf("Sending data to\n");
    for(i=0; i<6; i++)
        printf("%02X ", broadcast[i]);
    printf("\n");
    
    mbed_mac_address(my_mac);
    
    set_from_mac( eth_txs_buffer, my_mac );
    
    printf("Sending data from\n");
    for(i=0; i<6; i++)
        printf("%02X ", my_mac[i]);
    printf("\n");
    
    set_ether_type( eth_txs_buffer, ETHER_TYPE );

    memset( eth_txs_buffer + PAYLOAD_OFF, 'Z', NUM_PAYLOAD );

    printf("Flooding Data...\n");
    forever
    {
        eth.write( eth_txs_buffer, PAYLOAD_OFF + NUM_PAYLOAD );
        eth.send();
        wait_ms(1*SEC);
    }
}

