
#ifndef PCA9534_H
#define PCA9534_H

#include "mbed.h"

class DigitalEncoder
{
private:
    I2C *_i2c;
    InterruptIn *_irq;
    int  _address;

public:
    enum BIT_LOC {
        B0, B1, B2, B3, B4, B5, B6, B7
    };
    enum INC_LED{ R, G, B};
    DigitalEncoder(void(*incrementalChange)(void));
    int read(void);
    int read(BIT_LOC bit);
    int write(char val);
    int write(BIT_LOC bit);
    void SetLed(INC_LED led);
    void ResetLed(INC_LED led);
    void SetLed(INC_LED led, bool value);
    
private:
    char readRegister(char reg);
    int writeRegister(char reg, char val);
    int input(char val);
    int input(BIT_LOC bit);
    int output(char val);
    int output(BIT_LOC bit);

};

#endif
