
#include "DigitalEncoder.h"

char DigitalEncoder::readRegister(char reg)
{
    char msg[2] = {reg, 0};
    _i2c->write(_address, msg, 1, 1);
    _i2c->read((_address|1), msg, 1);
    return msg[0];
}

int DigitalEncoder::writeRegister(char reg, char val)
{
    char msg[] = {reg, val};
    return _i2c->write(_address, msg, 2);
}

DigitalEncoder::DigitalEncoder(void(*incrementalChange)(void))
{
    _i2c = new I2C(p9, p10);
    _address = 0x40;
    _i2c->frequency(400000);
    _irq = new InterruptIn(p8);
    if (_irq != 0) {
        _irq->fall(incrementalChange);
    }
    printf("------------Register %d", ~((1<<2)|(1<<3)|(1<<4)));
    DigitalEncoder::output((1<<2)|(1<<3)|(1<<4));
}

int DigitalEncoder::input(char val)
{
    return writeRegister(3, val);
}

int DigitalEncoder::input(BIT_LOC bit)
{
    return input((1<<bit));
}

int DigitalEncoder::output(char val)
{
    printf("%d",~val);
    return writeRegister(3, ~val);
}

int DigitalEncoder::output(BIT_LOC bit)
{
    return output(~(1<<bit));
}

int DigitalEncoder::read(void)
{
    return readRegister(0);
}

int DigitalEncoder::read(BIT_LOC bit)
{
    char val = readRegister(0);
    return ((val&(1<<bit))==(1<<bit)) ? 1 : 0;
}

int DigitalEncoder::write(char val)
{
    return writeRegister(1, val);
}

int DigitalEncoder::write(BIT_LOC bit)
{
    char val = readRegister(1);
    return write(val | (1<<bit));
}

void DigitalEncoder::SetLed(INC_LED led)
{
    BIT_LOC bit;
    switch(led)
    {
        case R: bit = B2; break;
        case G: bit = B3; break;
        case B: bit = B4; break;
        default: break;
    }
    char val = readRegister(1);
    write(val & (~(1<<bit)));
}

void DigitalEncoder::ResetLed(INC_LED led)
{
    BIT_LOC bit;
    switch(led)
    {
        case R: bit = B2; break;
        case G: bit = B3; break;
        case B: bit = B4; break;
        default: break;
    }
    char val = readRegister(1);
    write(val | (1<<bit));
}

void DigitalEncoder::SetLed(INC_LED led, bool value)
{
    if(value)
        DigitalEncoder::SetLed(led);
    else
        DigitalEncoder::ResetLed(led);
}