#include "mbed.h"
#include "hcsr04.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"

HCSR04  distSens(p25,p6);
Serial pc(USBTX, USBRX);
Speaker mySpeaker(p18);
uLCD_4DGL uLCD(p9,p10,p11);

unsigned int dist;
float averageDistance();
void beeping();
float i;

int main()
{
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.locate(10, 12);
    uLCD.color(BLUE);
    uLCD.printf(" Reverse           Sensor");
    uLCD.rectangle(65, 117, 126, 127, 0x0000FF);
    while(1) {
        distSens.start();
        averageDistance();
        beeping();
        uLCD.filled_rectangle(66, 118, 125, 127, 0x000000);
        pc.printf("cm:%d\n",dist );
        uLCD.text_width(1);
        uLCD.text_height(1);
        uLCD.locate(10, 15);
        uLCD.color(WHITE);
        uLCD.printf("cm:%1d\n",dist );
    }
}
float averageDistance()
{
        int a = distSens.get_dist_cm();
        int b = distSens.get_dist_cm();
        int c = distSens.get_dist_cm();
        int d = distSens.get_dist_cm();
        int e = distSens.get_dist_cm();
        int f = distSens.get_dist_cm();
        int g = distSens.get_dist_cm();
        int h = distSens.get_dist_cm();
        int i = distSens.get_dist_cm();
        int j = distSens.get_dist_cm();
 
        dist  = (a+b+c+d+e+f+g+h+i+j)/10;
        return dist;
}
void beeping()
{
    int distance = averageDistance();
    //sensor defaults to 2k+ when dist<~3cm 
    if (distance > 2000) i=0.05; 
    if (distance < 150) i=0.6;
    if (distance < 100) i=0.55;
    if (distance < 90) i=0.5;
    if (distance < 80) i=0.45;
    if (distance < 70) i=0.4;
    if (distance < 60) i=0.35;
    if (distance < 50) i=0.3;
    if (distance < 40) i=0.25;
    if (distance < 30) i=0.2;
    if (distance < 20) i=0.15;
    if (distance < 10) i=0.1;
    if (distance < 5) i=0.05;
    mySpeaker.PlayNote(600, i, 5.0);  
}