#include "mbed.h"
#include "camera_api.h"
#include "TFC.h"
#define clk 2  //ms
#define task_ma_time
#ifdef task_ma_time
DigitalOut cam_p(PTE5); 
#endif

BX_camera::BX_camera(int p)
{
 
    line_CamR = new FastAnalogIn(PTD5);
    line_CamL=   new FastAnalogIn(PTD6,0);
    cam_clk=new DigitalOut(PTE1);
    si=new DigitalOut(PTD7);
    padding = p;
}
int BX_camera::black_centerR(void)
{

    int l_care=10;
    int r_care=64;
    int b_start=0;
    int b_end=0;
    bool l_f1=false;
    bool l_f2=false;
    bool find=false;
    int b_thr_up=20;
    int b_thr_dn=5;
    int b_w=0;
    
     for(int i=r_care;i>l_care;i--){
         
         
          if(l_f1==false&&sign_line_imageR[i]==' '){
               
              b_start=i;
              l_f1=true;
          }
          if(l_f1==true && sign_line_imageR[i]=='O'){
              b_end=i-1;
              l_f2=true;   
           }
         
           if(l_f1==true && l_f2== true){
               b_w=b_start-b_end;
               if( b_thr_up>b_w&&b_w> b_thr_dn){
                   
                   find=true;     
                   break;
                }
                else{
                   l_f1=false;
                   l_f2=false;
                   
                } 
                
                   
            }
               
               
    }
         
         
         
     

  if(find)
     return (b_start+b_end)/2;
  else
     return -1;  
}   


int BX_camera::black_centerL(void)
{

    int l_care=64;
    int r_care=115;
    int b_start=0;
    int b_end=0;
    bool l_f1=false;
    bool l_f2=false;
    bool find=false;
    int b_thr_up=20;
    int b_thr_dn=4;
    int b_w=0;
    
     for(int i=l_care;i<r_care;i++){
         
         
          if(l_f1==false&&sign_line_imageL[i]==' '){
               
              b_start=i;
              l_f1=true;
          }
          if(l_f1==true && sign_line_imageL[i]=='O'){
              b_end=i-1;
              l_f2=true;   
           }
         
           if(l_f1==true && l_f2== true){
               b_w=b_end-b_start;
               if( b_thr_up>b_w&&b_w>= b_thr_dn){
                   
                   find=true;     
                   break;
                }
                else{
                   l_f1=false;
                   l_f2=false;
                   
                } 
                
                   
            }
               
               
    }
         
         
         
     

  if(find)
     return (b_start+b_end)/2;
  else
     return -1;  
}   



 
void BX_camera::read(void)
{
 
    w_f_vL=0x0000;
    b_f_vL=0xffff;
 
    w_f_vR=0x0000;
    b_f_vR=0xffff;
 
 
     line_CamR->enable();
 
    *si=1;
    *cam_clk=1;
 
    wait_us(30);   // tune here
    *si=0;
    *cam_clk=0;
 
 
   
    
 
 
    //input 128 //both
 
    for(int i=0; i<128; i++) {
        *cam_clk=1;
        wait_us(5);
 
 
        line_imageR[i]=line_CamR->read_u16();
  
      
      
       
 
        //  big small
        if(line_imageR[i] > w_f_vR)
            w_f_vR=line_imageR[i];
        else if(line_imageR[i] < b_f_vR )
            b_f_vR = line_imageR[i];
 
 
 
 
 
        *cam_clk=0;
        wait_us(5);
 
 
    }
   line_CamR->disable();
 
  *si=1;
    *cam_clk=1;
 
    wait_us(30);   // tune here
    *si=0;
    *cam_clk=0;
 
 
    
    cam_p=1;
    line_CamL->enable();
     for(int i=0; i<128; i++) {
        *cam_clk=1;
        wait_us(5);
 
 
    
  
      
      
        line_imageL[i]=line_CamL->read_u16();
 
        //  big small
     
 
        if(line_imageL[i] > w_f_vL)
            w_f_vL=line_imageL[i];
        else if(line_imageL[i] < b_f_vL )
            b_f_vL = line_imageL[i];
 
 
 
 
        *cam_clk=0;
        wait_us(5);
 
 
    }
    
    
   
  
    line_CamL->disable();
     cam_p=0; 
 
    //filter L R   //may change
 
    for(int i=0; i<128; i++) {
 
 
        if( (line_imageR[i]-b_f_vR) < (w_f_vR - line_imageR[i] )    )
            sign_line_imageR[i]=' ';
        else
            sign_line_imageR[i]='O';
 
 
        if( (line_imageL[i]-b_f_vL) < (w_f_vL - line_imageL[i] )    )
            sign_line_imageL[i]=' ';
        else
            sign_line_imageL[i]='O';
 
 
 
 
 
        if(i==0) {
            sign_line_imageR[i]='X';
            sign_line_imageL[i]='X';
        }
 
 
    }
 
 
 
}