/*
 * mbed library for Stack
 * Copyright (c) 2011 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file Stack.h
 * @brief Stack
 */

#ifndef Stack_H
#define Stack_H

#include "mbed.h"

/** Stack class
 */
template <class T>
class Stack {
public:
    /** init Stack class
     * @param p_size size of stack
     */
    Stack (int p_size);
    ~Stack ();

    /** push to stack
     * @param dat data
     * @return data or -1:error
     */
    int push (T dat);

    /** pop from stack
     * @param dat data
     * @return 0:ok / -1:error
     */
    int pop (T *dat);

    int read (T *dat);

    void clear ();
    int available ();
    int use ();

private:
    T *buf;
    int size;
    int addr;
};

#endif
