#include "mbed.h"
#include "SDFileSystem.h"
#include "DS1820.h"
#include "RHT03.h" //Include neede to use the RHT03 lib
/*******************************************************************************************/
DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);
Serial gps(PTC17, PTC16);
AnalogIn ps(PTB10);//(A2);
AnalogIn qc(PTB11);//(A2);

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
DS1820  ds1820(PTB3);    // substitute PA_9 with actual mbed pin name connected to the DS1820 data pin    
/*******************************************************************************************/
FILE *fp;
char gps_data[255];
/*******************************************************************************************/

int main()
{
    int i,rlock,stn;
    char gps_data[256],str1[25],str2[25];
    char ns,ew,aval,modi,mv,mi;
    float utctime,hokui,tokei;
    float g_hokui,g_tokei;
    float d_hokui,m_hokui,d_tokei,m_tokei;
    int h_time,m_time,s_time,d_date,m_date,a_date;
    float speed,course,utcdate,magvar;
    int j;
    float v1,v2,temp;
    int done=0;
    float temp2,hum;
    RHT03 humtemp(PTB2); //Initalise the RHT03 (change pin number to the pin its connected to)
      
    wait(2);
    pc.baud(115200);
    gps.baud(9600);
    pc.printf("\nHello World! I am ALPINHA 4\n");
    mkdir("/sd/test1", 0777);
    fp = fopen("/sd/GPS.txt", "w");
    if (fp == NULL) 
    {          // that it was created.
        pc.printf("\nnao possivel abrir o arquivo\n");;           // Return error.
    } else 
    {
        pc.printf("\n arquivo aberto para escrita\n");;           // Return error.
    }
    fprintf(fp, "1.txt in test 1");
    fclose(fp);
    ds1820.begin();
    ds1820.setResolution(12);
    ds1820.startConversion();
    wait(1.0);                  // let DS1820 complete the temperature conversion
    pc.printf("temp = %3.3f\r\n", ds1820.read());     // read temperatura            
    while (1) 
    { 
        if(humtemp.readData() == RHT_ERROR_NONE) done=1; //Request data from the RHT03   
        temp2 = humtemp.getTemperatureC(); //Gets the current temperature in centigrade
        hum = humtemp.getHumidity(); //Gets the current humidity in percentage  
      i=0;
      while(gps.getc()!='$');       
      while( (gps_data[i]=gps.getc()) != '\r') i++;      
      gps_data[i]='\0'; 
      aval='\0';
      v1=0.0;v2=0;
      for (j=0;j<20;j=j+1)
      {
        v1 =v1+ps*3300;//.read();
        v2 =v2+qc*3300;//.read();
      }
      v1=v1/20.0;v2=v2/20.0;
      if((gps_data[2]=='R')&(gps_data[3]=='M')&(gps_data[4]=='C'))      
      {
        temp=ds1820.read();   
        ds1820.startConversion();        
        for(j=0;j<i-1;j++) if(gps_data[j]==',') gps_data[j]=' ';   
        sscanf(gps_data,"%s %f %c %f %c %f %c %f %f %f %s",   str1,&utctime,&aval,&hokui,&ns,&tokei,&ew,&speed,&course,&utcdate,str2);      
      //if(aval=='A')
        {
            //latitude
            d_hokui = int(hokui/100);
            m_hokui = (hokui - d_hokui*100)/60;
            g_hokui = d_hokui + m_hokui;
            //longitude
            d_tokei = int(tokei/100);
            m_tokei = (tokei - d_tokei*100)/60;
            g_tokei=d_tokei + m_tokei;
          
            //time set
            h_time = int(utctime/10000);
            m_time = int((utctime - h_time*10000)/100);
            s_time = int(utctime - h_time*10000 - m_time*100);
          
            //date set
            d_date = int(utcdate/10000);
            m_date = int((utcdate - d_date*10000)/100);
            a_date = int(utcdate - d_date*10000 - m_date*100);
          
            pc.printf("%02d/%02d/%02d %02d:%02d:%02d %c %4.6f %4.6f %4.6f %3.3f %3.3f %3.3f --->%f %f\n",d_date,m_date,a_date,h_time,m_time,s_time,aval,g_hokui,g_tokei,speed,temp,temp2,hum,v1,v2);       
            fp = fopen("/sd/alpinha2.txt", "a");
            if (fp == NULL) 
            {          // that it was created.
                pc.printf("\nnao possivel abrir o arquivo\n");           // Return error.
            } else
                fprintf(fp,"%2d/%2d/%2d %2d:%2d:%2d %c %4.6f %4.6f %4.6f %3.3f %3.3f %3.3f %3.3f %3.3f\r\n",d_date,m_date,a_date,h_time,m_time,s_time,aval,g_hokui,g_tokei,speed,temp,temp2,hum,v1,v2);       
            fclose(fp);
        }           
          
    }
}
 }     
   
         
 
    
    


