#ifndef SEND_PC1403
#define SEND_PC1403

#include "mbed.h" 

#include "serial_file.h" // file-over-serial
#ifndef FILE_BUF_SIZE 
#include "bin_file.h"  // hardcoded file stream
#endif

#include "bit_send.h"

// remapping to MBed types
#define uchar  uint8_t
#define ushort uint16_t
#define uint   uint32_t
#define ulong  uint32_t

#define  PC_ID          1403 
#define  TYPE_BIN_ADDR  0xE030 

//  bit timings
#define BIT_DURATION       (8*250) // us, PC1403
#define SYNC_DURATION      1       // seconds
#define N_SYNC_BITS        SYNC_DURATION * 1000000 / BIT_DURATION  
#define MAX_BIT_TIME_ERR   50000 // timing error, per bit: 50ms - UNLIKELY!!

#define argP "" // main NOT using command-line input arguments

////////////////////////////////////////////////////////////////////////////////
// Excerpts from Pocket-Tools source code below
// https://www.peil-partner.de/ifhe.de/sharp/

/* Regular Errors such as EOF and recoverable such as End of sync *MUST* have a lower value then ERR_OK */
#define ERR_NOK        -1   /* also normal EOF */
#define ERR_OK          0

/* Unexpected NOT recoverable error *MUST* have a higher value then ERR_OK */
#define ERR_SYNT        1   /* arguments missed, syntax error */
#define ERR_ARG         3   /* arguments problem, pocket not implemented */
#define ERR_FILE        5   /* File I-O */
#define ERR_MEM         6   /* Line to long, buffer overflow, too much lines */
#define ERR_FMT         7   /* Source file format or size */
#define ERR_SUM         8   /* Constellation will generate a checksum error on PC */

#define TYPE_NOK        0
#define TYPE_BIN        1
#define TYPE_IMG        2
#define TYPE_VAR        3   /* one variable block without file type and name*/
#define TYPE_DAT        4
#define TYPE_RSV        5   /* For PC-1500, other re-transfer: IMG-compatible */
#define TYPE_ASC        6   /* For PC-E/G/1600 ASCII Data */
#define TYPE_BAS        7   /* For PC-E/G/1600 ASCII Source */
#define TYPE_TXT        8   /* For GRP_NEW, GRP_EXT and GRP_E text modus Image Data */
#define TYPE_DEF        9   /* For PC-1500 software, binary image for definable keys */
#define TYPE_DIM        10  /* For PC-1500 Quick-Tape, binary image of all dimensioned data variables */
#define TYPE_MEM        0x6E    /* Tables and Variables of PC-1150, subtype of TYPE_IMG */
#define TYPE_CRD        0x6A    /* PC-1100 full RAM card, subtype of TYPE_IMG */
#define TYPE_TEL        0x61    /* Telephone database export */
#define TYPE_SCD        0x62    /* Scheduler database export  */
#define TYPE_NOT        0x64    /* Notes database export */

#define GRP_OLD         0x20
#define GRP_NEW         0x70
#define GRP_EXT         0x72
#define GRP_DAT         0x74
#define GRP_16          0x10    /* PC-1600 */
#define GRP_E           0x05    /* PC-E500 */
#define GRP_G           0x08    /* PC-G850, E2xx */

#define IDENT_PC1211    0x80
#define IDENT_PC121_DAT 0x8F    /* one variable length block only, not tested */

#define IDENT_PC1500    0xA
#define IDENT_PC15_BIN  0xA0
#define IDENT_PC15_BAS  0xA1
#define IDENT_PC15_RSV  0xA2
#define IDENT_PC15_DEF  0xA3
#define IDENT_PC15_DAT  0xA4

#define IDENT_QTAPE     0x0AA0
#define IDENT_QT_BAS    0x42    // B
#define IDENT_QT_BIN    0x4D    // M
#define IDENT_QT_RSV    0x52    // R
#define IDENT_QT_DIM    0x44    // D = V DIM
#define IDENT_QT_DAT    0x56    /* V NOT implemented, UNSUPPORTED! */

#define IDENT_OLD_BAS   0x20
#define IDENT_OLD_PAS   0x21
#define IDENT_OLD_DAT   0x24
#define IDENT_OLD_BIN   0x26

#define IDENT_NEW_TEL   0x61    // MEMO  TEL  NEW DB
#define IDENT_NEW_SCD   0x62    // MEMO  SCDL NEW DB
#define IDENT_NEW_NOT   0x64    // MEMO  NOTE NEW DB
#define IDENT_NEW_CRD   0x6A    // BASIC RAM Card IN
#define IDENT_OLD_MEM   0x6E    // MEM OLD DB, all Tables

#define IDENT_NEW_BAS   0x70
#define IDENT_NEW_PAS   0x71
#define IDENT_EXT_BAS   0x72
#define IDENT_EXT_PAS   0x73
#define IDENT_NEW_DAT   0x74    // IDENT_DATA_VAR 0xEF removed
#define IDENT_NEW_BIN   0x76
#define IDENT_NEW_CSL   0x7A    // CASL or CAP-X CMT
#define IDENT_UNKNOWN   0x100

#define IDENT_ST        0x124   /* SuperTape */

#define IDENT_PC16_CAS  0x00    /* PC-1600 ASCII Data or BASIC Image */
#define IDENT_PC16_DAT  0x08    /* Special binary data format PC-1600 */
#define IDENT_E_ASC     0x04    /* ASCII Data or Text Modus BASIC/ASM/C Source */
#define IDENT_E_BAS     0x02    /* Return from Bas2Img also in the format of PC-1475 */
#define IDENT_E_BIN     0x01    /* Binary Data, use --addr parameter 2nd time for entry address */
                                /* also used for Rsv-Data, but different sub id (mode 2) */
#define SYNC_E_HEAD     40      /* additional sync for E-series header block */
#define SYNC_E_DATA     20      /* additional sync for E-series data block */

#define DATA_HEAD_LEN   5       /* length of the header of a data variable element*/
#define DATA_VARIABLE   0xFE00  /* Header element of standard variable, not length */
#define DATA_DBL_LEN    14      /* length of a double numeric data variable element */
#define DATA_STD_LEN    8       /* length of a numeric and standard data variable element*/
#define DATA_NUM_15     0x88    /* ItemLen = Id of numeric data variable of PC-1500 */

#define DATA_NUM        0x98    /* Internal identity of numeric data variable */
#define DATA_STR        0xA8    /* Internal identity of a string data variable */
#define DATA_UNKNOWN    0x00    /* Variable filled with zeros */

#define DATA_STD_STR    0xF5    /* Standard data variable is a string */
#define DATA_EOF        0x0F    /* End of variable Data Block */

#define EOF_ASC         0x1A    /* End of ASCII transfered files, also CAS: of newer series */
#define EOF_15          0x55    /* End of complete file of PC-1500 */
#define BAS_1500_EOF    0xFF    /* one of two bytes */
#define BAS_NEW_EOF     0xFF    /* one of two bytes */
#define BAS_OLD_EOF     0xF0    /* one byte only */

#define BLK_OLD_SUM     8       /* Transmission Block (plus checksums), old series bas without, data old/new with checksum reset */
#define BLK_OLD         80      /* Transmission Block (plus checksums) of PC-1500 and old series with checksum reset */
#define BLK_NEW         120     /* Transmission Block (plus checksum) of new series 1260-1475 */
#define BLK_E_DAT       256     /* Checksum of series E500 DAT */
#define BLK_E_HEAD      0x30    /* Length of header1 of series E500, next only after the end of a Transmission Block */
#define BLK_S_HEAD      25      /* Length of SuperTape Header without checksum */

#define SUPT_HEAD_L     26      /* SuperTape length of header block with low byte of checksum included */
#define SUPT_SYN_NB     64      /* SuperTape number of synchronisation char */
#define SUPT_SYNC       0x16    /* SuperTape SYNCHR synchronisation char */
#define SUPT_HEAD       0x2A    /* SuperTape SYNPGM start mark of header block */
#define SUPT_DATA       0xC5    /* SuperTape SYNDAT start mark of program/data block */
#define SUPT_END        0x9B    /* SuperTape end mark after the checksum of a block */
#define SUPT_FLAGS      0x00    /* SuperTape flag byte */

#define BGNSAMPLES      44      /* first sample byte */

#define AMP_MID         0x80    /* Sample value for silence (all 8-bit) */
#define AMP_HIGH        0xDA    /* Sample value for amplitude HIGH */
#define AMP_LOW         0x26    /* Sample value for amplitude LOW */
#define AMP_HIGH_E      0xFC    /* Sample value for amplitude HIGH for E-series */
#define AMP_LOW_E       0x04    /* Sample value for amplitude LOW for E-series */
#define AMP_HIGH_121    0xEF    /* Sample value for amplitude HIGH for CE-121 */
#define AMP_LOW_121     0x11    /* Sample value for amplitude LOW for CE-121 */

#define ORDER_STD       0
#define ORDER_INV       1
#define ORDER_S         8       /* SuperTape Byte */
#define ORDER_E         9       /* 1600-Series and newer, no nibbles, a byte */
#define ORDER_Q         11      /* Quick-Tape PC-1500a byte */

#define BASE_FREQ1      4000
#define BASE_FREQ2      2500    /* PC-1500 */
#define BASE_FREQ3      3000    /* PC-E-series and newer */
#define BASE_FREQ4      5000    /* Quick-Tape */
#define BASE_FREQS      3600    /* SuperTape */

#define CHAR_SPACE      0x20
#define CHAR_DOT        0x2E
#define CHAR_COLON      0x3A
#ifdef __linux__                /* path separator */
   #define CHAR_SLASH   0x2F
//elif defined __APPLE__
#endif
#ifdef __APPLE__
   #define CHAR_SLASH   0x2F
#endif
#ifndef CHAR_SLASH              /* Windows path separator */
   #define CHAR_SLASH   0x5C
#endif
#define CHAR_UNDERSCORE 0x5F

#define cVL             80      /* Constant value for max. length of a data variable */
#define cLL             512     /* Constant value for max. length of CFG-TEXT lines and max. CFG line Nb */
#define cLPF            100     /* Constant value for max. Length of PathFilenames */

#define BAS_EOF_INCL  0x200000 /* debug flag for one included End Mark from Bas2img or Wav2bin */
#define DATA_W2B150     0x8000 /* debug flag for DAT-IMG from Wav2bin 1.5.0 or older */
#define NO_FILE_HEAD    0x4000 /* debug flag, write without file type and -name, 2.variable block */
#define BAS_EXT_FRMT    0x1000 /* debug flag, use FORMAT of BAS_EXT for E-Series */
#define SYNCL_STD       0x400  /* debug flag, for default sync length like the original */
#define SYNCL_TRM       0x200  /* debug flag, for sync length like the Technical Reference Manual */

#define MODE_B22        0   /* PC-1500 */
#define MODE_B21        1
#define MODE_B20        2
#define MODE_B19        3   /* Old series */
#define MODE_B17        4
#define MODE_B16        5   /* File names of new series an data */
#define MODE_B15        6   /* Variable data body new series */
#define MODE_B14        7   /* PC-1403 and newer, reads also B13 */
#define MODE_B13        8   /* PC-1402 */
#define MODE_B9         9   /* PC-E series and newer */
#define MODE_B10        10  /* SuperTape */
#define MODE_B11        11  /* Quick-Tape */


///////////////////////////////////////
// bin-2-wav typedefs
typedef struct {
    // FILE*  ptrFd ;  /* FILE NOT USED HERE */
    uint  ident ;
    uchar  mode ;       /* Bit writing mode and stop bits*/
    uchar  mode_h ;     /* Bit writing mode and stop bits for the file header*/
    ulong  nbSync1 ;    /* sync bits per second */
    ulong  nbSync ;     /* sync bits for intermediate syncs */
    ulong  nbByte ;     /* size of bytes to write */
    ulong  total ;      /* total bytes written (without checksums) */
    long   total_diff ; /* difference between bytes read and written (without checksums) */
    ulong  count ;      /* Counter of bytes in a block for the checksum */
    ulong  sum ;        /* Checksum calculated */
    ulong  block_len ;  /* Block length for checksum, variable used for E-Series */
    ulong  usedat_len ; /* Length of useful data of the next block 1...(0x50), for Qtape L:0...4F */
    ulong  bitLen ;     /* Wave sample blocks per SHARP bit */
     bool  lastSmpHigh; /* for SuperTape phase switching */
    ulong  debug ;
} FileInfo ;  

typedef struct {
    uint  stopb1 ;
    uint  stopb2 ;
} ModeInfo ;

extern FileInfo  fileInfo ; // extern, for other modules too

///////////////////////////////////////
// static variables
static ModeInfo Mode[] = { /* stop bits of first and second nibble */
    { 6, 6 }, { 5, 6 }, { 5, 5 }, { 4, 5 },
    { 1, 6 }, { 1, 5 }, { 1, 4 }, { 1, 3 }, { 1, 2 }
} ;

static bool bitMirroring = false ;

const static char CodeOld[] = {
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x14,0x12,0x15,0x18,0x16,0x1F,0x11, // Pos. 0x24 $ 0x19 -> 0x18, 11/2020
    0x30,0x31,0x37,0x35,0x1B,0x36,0x4A,0x38,
    0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
    0x48,0x49,0x1D,0x1C,0x33,0x34,0x32,0x13,
    0x1E,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
    0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
    0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
    0x68,0x69,0x6A,0x11,0x11,0x11,0x39,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x19,0x11,0x1A,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11
} ;


////////////////////////////////////////////////////////////////////////////////
// published method
int sharp_fileloop ( FileInfo*  ptrFile ) ;
int FileSend ( void );

// From Pocket Tools
int WriteSaveNameToWav (char*  ptrName,
                        uchar  mode);
int WriteFooterToMemoWav ( void );
int WriteSyncToWav (ulong  nbSync);
int WriteByteSumToWav (ulong  value,
                       uchar  order,
                       uchar  mode);
int WriteByteSumToWav (ulong  value,
                       uchar  order,
                       uchar  mode);

#endif // SEND_PC1403