/********************************************
Send File to Sharp PC-1403(H)
==========================================

Author: Fabio Fumi
Date:   04.03.2022

This software comes with the GNU public licence (GPL).

It is an adaptation to the Mbed OS of the 
img2wav from the "Pocket Tools" suite
https://www.peil-partner.de/ifhe.de/sharp/
*********************************************/
#include "mbed.h" 
#include "send_pc1403.h"
//#ifdef FILE_BUF_SIZE
//volatile char debugOut[1024];
//#endif
RawSerial   pc(USBTX,USBRX); // better than Serial, when using interrupts
DigitalOut  my_led(LED1);
DigitalIn   my_button(USER_BUTTON);
InterruptIn btn(USER_BUTTON);
Timer       total_time;
Ticker      blink;

 // bin-to-wav conversion information (from Pocket Tools code)
int       send_err;

void ledBlink () {
    my_led = !my_led;
}

#ifdef FILE_BUF_SIZE 
void printInfo() 
{
    int i ;
    // printout info
    pc.printf("totBytesReceived %d\n\r", totBytesReceived);
    pc.printf("fileBufReceivePtr %d\n\r", fileBufReceivePtr);
    for ( i=0; i<10; i++ ) 
        pc.printf("0x%.2X ", fileOverSerialBuffer[i] );
    pc.printf("...\n\r");
    pc.printf("fileBufSendPtr %d\n\r", fileBufSendPtr);
    //pc.printf("<%s>\n\r", debugOut);
    pc.printf("fileReceiveComplete %d\n\r", fileReceiveComplete);
    pc.printf("fileError %d\n\r", fileError);
    pc.printf("fileInfo.total %d\n\r", fileInfo.total);
    pc.printf("time (ms): %d [send_err %d]\n\r", total_time.read_us()/1000, send_err);
    
}

// invoked at each character received over serial
void serial_rx() {
    
    // getting data from serial
    if ( totBytesReceived == 0 ) {
        timeout.start(); // new file: enable a watchdog
        timeout.reset();
        blink.attach( &ledBlink, 0.05 ); // fast blink: receiving
    }
    // push character on the circular buffer
    filePushData ( pc.getc() );
    totBytesReceived++;
    timeout.reset();

}
#endif

 
int main()
{
    
    my_led = 0;
    pc.baud(600); // file-over-serial can't go faster (sending to Sharp is about 500baud)
    fflush(stdout);
#ifdef FILE_BUF_SIZE 
    btn.rise(&printInfo);
    pc.attach(&serial_rx, Serial::RxIrq);
    fileReceiveInit( );
#endif
    // main loop
    while(true) {
        
        blink.attach( &ledBlink, 1.0 ); // slow blink - waiting for file
        
#ifdef FILE_BUF_SIZE 
        // File-over-serial
        // serial interrupt - pushing to buffer
        // main thread - pulling from buffer
        fileInfo.debug = 0x1000; // disable verbose printf while using serial
        fileReceiveInit( ); 
        // wait for data available, before starting to send  
        while ( !totBytesReceived  ) 
            wait (.1);
#else
        // hardcoded BIN file
        pc.printf("Push user button to start sending \n\r"); 
        // wait for button pressed, only for the hardcoded BIN file
        while ( my_button == 1 )
            wait ( .1 );
#endif
        
        // start sending new file to Sharp
        fileInfo.ident = IDENT_NEW_BAS;
        fileInfo.debug = 0x0040; // 0x0000 disable printf; 0x0040 DEBUG
        bitHandlerInit(); // new bit stream being sent
        total_time.reset();
        total_time.start();
        send_err = FileSend ( ) ;  // removed for debug !
        bitHandlerStop(); // stop bit consumer, after last bit
        while( bitHandlerRunning() )  // time for bit handler to complete
            wait (.1); 
        total_time.stop();
#ifdef FILE_BUF_SIZE 
        printInfo() ;
#endif
        pc.printf("DONE - time (ms): %d [send_err %d]\n\r", total_time.read_us()/1000, send_err);

        // doing nothing...
        wait(.1);       
               
    }
}