#ifndef BIT_SEND
#define BIT_SEND

#define BIT_TICK_DELAY      125 // us - 125 us = 4 Khz base freq
#define BIT_TICK_1_REPEAT   1  // nr. of ticks to stay on each output level
#define BIT_TICK_1_NCYCLES  16 // nr. of output level switching, per bit
#define BIT_TICK_0_REPEAT   2  // same for bit "0"
#define BIT_TICK_0_NCYCLES  8 

#define BIT_FIRST_SENT      ( 1UL << 0 ) // signal for first bit sent
#define BIT_LAST_SENT       ( 1UL << 1 ) // signal for last bit sent
#define BIT_LAST_PROCESSING ( 1UL << 2 ) // last bit is being processes
#define BIT_SENDING         ( 1UL << 3 ) // bit being processed

#ifdef FILE_BUF_SIZE
//extern volatile char debugOut[];  //  holding debug info to print at the end
//static char debugLine[128];
//#define debug_printf(f_, ...) { sprintf((char*)debugLine,(f_), ##__VA_ARGS__); strcat ( (char*)debugOut, debugLine ); }
#define debug_printf(f_, ...)
#else
#define debug_printf(f_, ...) printf((f_), ##__VA_ARGS__)
#endif

void bitHandlerInit( void ) ;
void bitHandlerStop ( void ) ;
int bitWaitSend ( uint8_t bit_value, uint8_t invert );
bool bitHandlerRunning( void ) ;

#endif