#include "serial_file.h"
// file-over-serial implementation, using a circular buffer
// between feeder, pushing data received from serial port,
// and consumer, pulling and sending to sharp PC
// Serial is not buffered on the MBed board
// Sharp PC data sending is timed by the bit-handler modulator
// Since neither can be stopped, assumptions are:
// - feeder must be faster than consumer
// - buffer (although circular) limits maximum size to be processed

Timer timeout;

// volatile because shared among 
volatile int totBytesReceived;
volatile int fileBufReceivePtr; 
volatile int fileBufSendPtr; 
volatile int fileReceiveComplete;
volatile int fileError;
volatile char fileOverSerialBuffer[FILE_BUF_SIZE];   // circular file buffer (for serial get)

extern DigitalOut  my_led;
extern Ticker      blink;

void  fileReceiveInit( void ) {
    
    totBytesReceived = 0;
    fileBufReceivePtr = 0; 
    fileBufSendPtr = 0; 
    fileReceiveComplete = false;
    fileError = 0;
    timeout.stop();
    timeout.reset();
    
}

char  filePullData ( void ) {
    return ( fileOverSerialBuffer[ ((fileBufSendPtr++)%FILE_BUF_SIZE) ] ); 
}

void   filePushData ( char byte ) {
    fileOverSerialBuffer[ ((fileBufReceivePtr++)%FILE_BUF_SIZE) ] = byte;
    if ( fileOverSerialBuffer[fileBufReceivePtr] == '0xFF' ) { // terminator char, force receive end
        fileReceiveComplete = true;
        fileError = ERR_FILE_TERMINATED;
        blink.detach( );
        my_led = 1;
        return;
    }
    if ( fileBufReceivePtr == fileBufSendPtr ) { // buffer not large enough, feeder reached consumer
        fileReceiveComplete = true;
        fileError = ERR_FILE_BUF_FULL;
        blink.detach( );
        my_led = 1;
        return;
    }
}

bool  isFilePullComplete( void ) {
  return ( fileBufSendPtr == fileBufReceivePtr - 1 ) ;
}
