#include "mbed.h"

//  Notes      
#define A4      440        
#define B4b     446         
#define C4      261
#define C4_1    130 
#define C5      523      
#define D4      293   
#define D4b     277               
#define E4      329          
#define F4      349           
#define G4      392  
 
const int notes[] = {C4_1,C4,D4,C4,F4,E4,C4_1,C4,D4,C4,G4,F4,C4_1,C4,C5,A4,F4,E4,D4,B4b,B4b,A4,F4,G4,F4};
const int intervals[] = {4, 4, 8, 8, 8, 10, 4, 4, 8, 8, 8, 10, 4, 4, 8, 8, 8, 8, 8, 4, 4, 8, 8, 8, 12};     

// speaker sound effect demo using PWM hardware output
PwmOut speaker(PA_0);
// serail port to PC (over USB)
Serial pc(USBTX, USBRX); // tx, rx
 
int main()
{
    int i;
    char c = 0;
    
    // Intro ( ta-dah @ 500Hz )
    speaker.period(1.0/500.0); // 500hz period
    speaker =0.5; //50% duty cycle - max volume
    wait(.05);
    speaker=0.0; // turn off audio
    wait(.05);
    speaker =0.5; //50% duty cycle - max volume
    wait(.5);
    speaker=0.0; // turn off audio
    
    pc.printf (" \n");
    pc.printf ("t=Tone, s=Sweep, p=Police, h=Song\n");
    
    while(c != ' ') {
       
       c=pc.getc();
       pc.printf("%c",c);
       wait(.1);
       
       switch (c)
       {
           case 't':
           pc.printf ("Tone...\n");
           // generate a short 150Hz tone using PWM hardware output
           // something like this can be used for a button click effect for feedback
           for (i=0; i<10; i++) {
              speaker.period(1.0/150.0); // 500hz period
              speaker =0.25; //25% duty cycle - mid range volume
              wait(.02);
           }
           speaker=0.0; // off
           break;
           
           case 's':
           pc.printf ("Sweep...\n");
           // sweep up in frequency by changing the PWM period
           for (i=0; i<8000; i=i+100) {
              speaker.period(1.0/float(i));
              speaker=0.25;
              wait(.02);
           }
           speaker=0.0; // off
           break;

           case 'p':
           pc.printf ("Police...\n");
           // two tone police siren effect - two periods or two frequencies
           // increase volume - by changing the PWM duty cycle
           for (i=0; i<10; i=i+2) {
              speaker.period(1.0/969.0);
              speaker = float(i)/50.0;
              wait(.5);
              speaker.period(1.0/800.0);
              wait(.5);
           }
           speaker=0.0; // off
           break;
           
           case 'h':
           pc.printf ("Happy birthday...\n");
           for (int i=0;i<=24;i++) {
               speaker.period(1.0/notes[i]);
               speaker=0.25;
               wait(0.8*intervals[i]/10);
           }
           speaker=0.0; // off
           break;
      }
   }
   pc.printf ("Bye...\n");
}