#include "mbed.h"
#include "neopixel.h"
#include "si5351a.h"

I2C i2c(D0, D1);                   //通信Si5351A
SI5351A clk(i2c, 25000000UL);      //基础时钟25MHz
Pixel Column[20];                  //单个数组
Pixel Column_All[280];             //全局数组
NeoPixelOut neoPixel(D9);          //数据输出
Timeout PeakDecrease;              

DigitalOut reset=D4;               //重置MSGEQ7
DigitalOut strobe=D3;              //选择MSGEQ7输出
AnalogIn analog1_7=A0;             //数据读取1-7
AnalogIn analog8_14=A1;            //数据读取8-14
//AnalogIn mod=A2;                  //选择模式输入
AnalogIn sensitive=A5;
AnalogIn brightness=A6;


int NumColumn=14;                  //灯柱数量
int Peak[14]={0};                 
int PeakDecreaseTime_us=50*1e3;    //peak下降延迟时间
int colorPeak;           //peak颜色
int __mode;
float freqData[14];
float noise=0.1;

float mode=0.1;
int num=0;


//-------------------------------设置Peak降落的互钳函数
void toggleOff(void);
void toggleOn(void){
    for(int i=0;i<NumColumn;i++){
        if(Peak[i]>-2) Peak[i]--;    
    }
    num++;
    if(num==200){
        if(mode<=0.5) mode=mode+0.1;
        else mode=0.1;
        num=0;
    }
    PeakDecrease.attach_us(toggleOff,PeakDecreaseTime_us);
}
void toggleOff(void){
    for(int i=0;i<NumColumn;i++){
        if(Peak[i]>-2) Peak[i]--;    
    }
    PeakDecrease.attach_us(toggleOn,PeakDecreaseTime_us);
}
//-----------------------------------------取最大值函数
int max(int i,int j){
    if(i>j)return i;
    else return j;
}
//---------------------------------------------读取MSGEQ7的返回值
void Read() {
    reset = 1;
    //wait_ns(150);    //最小值100ns
    reset = 0;
    wait_us(200);
    for (int i = 0; i < 7; i++){
        strobe = 0;
        wait_us(50);                      //待输出稳定
        freqData[i*2]=analog1_7*(0.5+2*sensitive);
        freqData[i*2+1]=analog8_14*(0.5+2*sensitive);
        strobe = 1;
        wait_us(40);             //strobe最小间隔72us，此处取90us 
    }
}
//-------------------------------------------初始颜色
int colorBegin(){
    int __mode=(int)(mode*10);    //__mode范围为1,2,3,4,5,6,7,8,9
    switch(__mode){
        case 1:
            colorPeak=0xFF0000;
            return 0x00FF00;//
        case 2:
            colorPeak=0xFF0000;
            return 0x0000FF;//
        case 3:
            colorPeak=0xFFFF00;
            return 0xFF33CC;//
        case 4:
            colorPeak=0x990099;
            return 0xFF3366;//
        case 5:
            colorPeak=0x0000FF;
            return 0x000000;//
        case 6:
            colorPeak=0xFF0000;
            return 0x00FF00;
        case 7:
            colorPeak=0xFF0000;
            return 0x00FF00;
        case 8:
            colorPeak=0xFF0000;
            return 0x00FF00;
        case 9:
            colorPeak=0xFF0000;
            return 0x00FF00;
        default:
            colorPeak=0xFF0000;
            return 0x00FF00;

    }
}
//------------------------------------------设置模式，每个数字对应一种颜色变换方式
int colorTransformation(int __color,int i){
    switch(__mode){
        case 1:
            return __color+0x060009-0x000B00;//绿色
        case 2:
            return __color+0x0B0000-0x00000C;//蓝色
        case 3:
            switch(i){
                case 0:return   0xFF33CC;    case 1:return   0xFF33FF;    case 2:return   0xCC33FF;    case 3:return   0x9933FF;     case 4:return    0x6633FF;    
                case 5:return   0x3333FF;    case 6:return   0x3366FF;    case 7:return   0x3399FF;    case 8:return   0x33CCFF;     case 9:return    0x33FFFF;    
                case 10:return  0x33FFCC;    case 11:return  0x33FF99;    case 12:return  0x33FF66;    case 13:return  0x33FF33;     case 14:return   0x66FF33;    
                case 15:return  0x99FF33;    case 16:return  0xCCFF33;    case 17:return  0xFFFF33;    case 18:return  0xFFCC33;     case 19:return   0xFF9933;   
                default: return  0x000000;
            }//粉黄
        case 4:
            switch(i){
                case 0:return   0xFF3366;    case 1:return   0xFF33CC;    case 2:return   0xCC33FF;    case 3:return   0x6633FF;     case 4:return    0x3366FF;    
                case 5:return   0x33CCFF;    case 6:return   0x33FFCC;    case 7:return   0x33FF66;    case 8:return   0x66FF33;     case 9:return    0xCCFF33;    
                case 10:return  0xFFCC33;    case 11:return  0xFF6633;    case 12:return  0xFF33CC;    case 13:return  0xFF33FF;     case 14:return   0x9933FF;    
                case 15:return  0x3333FF;    case 16:return  0x3399FF;    case 17:return  0x33FFFF;    case 18:return  0x33FF99;     case 19:return   0x33FF33;   
                default: return  0x000000;
            }//
        case 5:
            return 0X000000;//红色无
        case 6:
            return __color;
            break;
        case 7:
            return __color;
            break;
        case 8:
            return __color;
            break;
        case 9:
            return __color;
        default:
            return __color+0x06000C;

    }
}
//------------------------------------------确定单个column的颜色
void run(int j){
    __mode=mode*10;
    int __color=colorBegin();
    int H=((freqData[j]-noise)*19);
    for(int i=0; i<20; i++) {
        if(i>H) Column[i].hex=0;
        else Column[i].hex=__color;
        __color=colorTransformation(__color,i);  
    }
    Column[max(Peak[j],H)].hex=colorPeak;
    if(Peak[j]<H) Peak[j]=H;//当Peak小于H时，上拉Peak到最顶端
}
//-------------------------------------------main
int main()
{
    strobe=1;
    reset=0;                     //initialize
    clk.set_frequency(SI5351_CLK1, 104570);
    clk.set_frequency(SI5351_CLK0, 190000);
    wait_us(200*1000); // 等待HSE稳定
    neoPixel.normalize = false; // 使r+g+b=255 均匀每个led亮度
    //Peakdecrease.detach();
    toggleOn();//打开PeakDecrease
    while(1) {
        Read();
        neoPixel.global_scale = brightness; //亮度调节
        //for(int x=0;x<14;x++) printf("%4.d ",(int)(freqData[x]*100));//test
        //printf("\n");//test
        for(int j=0;j<NumColumn;j++){     
            run(j);
            for(int k=20*j;k<20*(j+1);k++){
                Column_All[k].hex=Column[k%20].hex;  
            }
        }
        neoPixel.send(Column_All, NumColumn*20);
    }
}