#ifndef DEVICE_H
#define DEVICE_H

#include "mbed.h"

static AnalogIn     buttonPort(p18);
static AnalogIn     encoderPort0(p20);
static AnalogIn     encoderPort1(p19);
static DigitalOut   mDirPort0(p30);
static DigitalOut   mDirPort1(p29);
static PwmOut       mSpeedPort0(p21);
static PwmOut       mSpeedPort1(p22);

class mdevice
{
public:
    mdevice ();
    void updateDeviceStatus();
    int  getButton();
    int  getMotorPos0();
    int  getMotorPos1();
    void runMotor0(float s);
    void runMotor1(float s);
    int  getButtonEdge();
private:
    bool mIndexSig0;
    bool mIndexSig1;
    int  mPos0;
    int  mPos1;
    int  mDir0;
    int  mDir1;
    int  mButton;
    int  mPreButton;
    int  mButtonEdge;
    void updateButton();
    void updateEncoder0();
    void updateEncoder1();

};

#endif