#include "mdevice.h"

mdevice::mdevice()
{
    mSpeedPort0.period(0.00002857142f);
    mSpeedPort1.period(0.00002857142f);   
    mIndexSig0=true;
    mIndexSig1=true;
    mPos0=0;
    mPos1=0;
    mDir0=1;
    mDir1=1;
    mButton=0;
    mPreButton=0;
    mButtonEdge=0;
}

void mdevice::updateButton()
{
    if (buttonPort>0.3f)
    {
        mButton=1;
    }
    else
    {
        mButton=0;
    }
    
    //detect up edge
    if (mPreButton==0&& mButton==1)
    {
        mButtonEdge=1;
    }  
    //detect down edge
    else if (mPreButton==1&& mButton==0)
    {
        mButtonEdge=-1;
    }
    else
    {
        mButtonEdge=0;
    }     
    mPreButton=mButton;
}

void mdevice::runMotor0(float s)
{
    if (s>0.001)
    {
        mDir0=1;
        mDirPort0=1;
        mSpeedPort0.write(s);
    }
    else if (s<-0.001)
    {
        mDir0=-1;
        mDirPort0=0;
        mSpeedPort0.write(-s);
    }
    else
    {
        mSpeedPort0.write(0.0f);
    }
}

void mdevice::runMotor1(float s)
{
    if (s>0.001)
    {
        mDir1=1;
        mDirPort1=1;
        mSpeedPort1.write(s);
    }
    else if (s<-0.001)
    {
        mDir1=-1;
        mDirPort1=0;
        mSpeedPort1.write(-s);
    }
    else
    {
        mSpeedPort1.write(0.0f);
    }
}

void mdevice::updateEncoder0()
{
    if (encoderPort0<0.3f )
    {
        if (mIndexSig0==true)
        {
            mIndexSig0=false;
            mPos0=mPos0+mDir0;
        }
    }
    else
    {
       mIndexSig0=true;
    }
}

void mdevice::updateEncoder1()
{
    if (encoderPort1<0.3f )
    {
        if (mIndexSig1==true)
        {
            mIndexSig1=false;
            mPos1=mPos1+mDir1;
        }
    }
    else
    {
       mIndexSig1=true;
    }
}

void mdevice::updateDeviceStatus()
{
    updateEncoder0();
    updateEncoder1();
    updateButton();
}

int mdevice::getButton()
{
    return mButton;
}

int mdevice::getMotorPos0()
{
    return mPos0;
}

int mdevice::getMotorPos1()
{
    return mPos1;
}

int mdevice::getButtonEdge()
{
    return mButtonEdge;
}

